/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.file;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.media.MediaReader;
import cool.scx.io.ByteInput;
import cool.scx.io.consumer.ByteConsumer;
import cool.scx.io.consumer.OutputStreamByteConsumer;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class FileMediaReader
implements MediaReader<File> {
    private final File file;
    private final boolean createDirs;
    private final OpenOption[] options;

    public FileMediaReader(File file, OpenOption ... options) {
        this(file, true, options);
    }

    public FileMediaReader(File file, boolean createDirs, OpenOption ... options) {
        this.file = file;
        this.createDirs = createDirs;
        this.options = options;
    }

    @Override
    public File read(ByteInput byteInput, ScxHttpHeaders headers) throws ScxIOException, AlreadyClosedException {
        Path path = this.file.toPath();
        try {
            if (this.createDirs && path.getParent() != null) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            try (OutputStream outputStream = Files.newOutputStream(path, this.options);){
                byteInput.readAll((ByteConsumer)new OutputStreamByteConsumer(outputStream));
            }
            return this.file;
        }
        catch (IOException e) {
            throw new ScxIOException((Throwable)e);
        }
    }
}

