/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.file;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media_type.FileFormat;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.sender.HttpSendException;
import cool.scx.io.ByteInput;
import cool.scx.io.ByteOutput;
import cool.scx.io.ScxIO;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;
import java.io.File;
import java.io.IOException;

public class FileMediaWriter
implements MediaWriter {
    private final File file;
    private final long length;
    private final ByteInput byteInput;

    public FileMediaWriter(File file) throws HttpSendException {
        this(file, 0L, file.length());
    }

    public FileMediaWriter(File file, long offset, long length) throws HttpSendException {
        this.file = file;
        this.length = length;
        try {
            this.byteInput = ScxIO.createByteInput((File)file, (long)offset, (long)length);
        }
        catch (IOException e) {
            throw new HttpSendException("\u8bfb\u53d6 file \u65f6\u53d1\u751f\u5f02\u5e38 !!!", e);
        }
    }

    @Override
    public long beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        if (responseHeaders.contentType() == null) {
            FileFormat fileFormat = FileFormat.findByFileName(this.file.getName());
            if (fileFormat == null) {
                responseHeaders.contentType(MediaType.APPLICATION_OCTET_STREAM);
            } else {
                responseHeaders.contentType(fileFormat.mediaType());
            }
        }
        return this.length;
    }

    @Override
    public void write(ByteOutput byteOutput) throws ScxIOException, AlreadyClosedException {
        try (ByteOutput byteOutput2 = byteOutput;
             ByteInput byteInput = this.byteInput;){
            this.byteInput.transferToAll(byteOutput);
        }
    }
}

