/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.gzip;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.headers.content_encoding.ContentEncoding;
import cool.scx.http.media.MediaWriter;
import cool.scx.io.ByteOutput;
import cool.scx.io.ScxIO;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;

public record GzipMediaWriter(MediaWriter mediaWriter) implements MediaWriter
{
    @Override
    public long beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        responseHeaders.contentEncoding(ContentEncoding.GZIP);
        this.mediaWriter.beforeWrite(responseHeaders, requestHeaders);
        return -1L;
    }

    @Override
    public void write(ByteOutput byteOutput) throws ScxIOException, AlreadyClosedException {
        ByteOutput gzipByteOutput = ScxIO.gzipByteOutput((ByteOutput)byteOutput);
        this.mediaWriter.write(gzipByteOutput);
    }
}

