/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.input_stream;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.io.ByteOutput;
import cool.scx.io.ScxIO;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamMediaWriter
implements MediaWriter {
    private final InputStream inputStream;
    private final boolean autoClose;

    public InputStreamMediaWriter(InputStream inputStream) {
        this(inputStream, true);
    }

    public InputStreamMediaWriter(InputStream inputStream, boolean autoClose) {
        this.inputStream = inputStream;
        this.autoClose = autoClose;
    }

    @Override
    public long beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        return -1L;
    }

    @Override
    public void write(ByteOutput byteOutput) throws ScxIOException, AlreadyClosedException {
        try (ByteOutput byteOutput2 = byteOutput;){
            this.inputStream.transferTo(ScxIO.byteOutputToOutputStream((ByteOutput)byteOutput));
        }
        catch (IOException e) {
            throw new ScxIOException((Throwable)e);
        }
        if (this.autoClose) {
            try {
                this.inputStream.close();
            }
            catch (IOException e) {
                throw new ScxIOException((Throwable)e);
            }
        }
    }
}

