/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.multi_part;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.http.media.multi_part.MultiPartPart;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.io.ByteChunk;
import cool.scx.io.ByteInput;
import cool.scx.io.ByteOutput;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;

public final class MultiPartMediaWriter
implements MediaWriter {
    private final MultiPart multiPart;

    public MultiPartMediaWriter(MultiPart multiPart) {
        this.multiPart = multiPart;
    }

    @Override
    public long beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        if (responseHeaders.contentType() == null) {
            responseHeaders.contentType(ScxMediaType.of(MediaType.MULTIPART_FORM_DATA).boundary(this.multiPart.boundary()));
        }
        return -1L;
    }

    @Override
    public void write(ByteOutput byteOutput) throws ScxIOException, AlreadyClosedException {
        ByteChunk h = ByteChunk.of((String)("--" + this.multiPart.boundary() + "\r\n"));
        ByteChunk f = ByteChunk.of((String)("--" + this.multiPart.boundary() + "--\r\n"));
        ByteChunk l = ByteChunk.of((String)"\r\n");
        try (ByteOutput byteOutput2 = byteOutput;){
            for (MultiPartPart multiPartPart : this.multiPart) {
                byteOutput.write(h);
                String headers = multiPartPart.headers().encode();
                byteOutput.write(ByteChunk.of((String)headers));
                byteOutput.write(l);
                try (ByteInput i = multiPartPart.byteInput();){
                    i.transferToAll(byteOutput);
                }
                byteOutput.write(l);
            }
            byteOutput.write(f);
        }
    }
}

