/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.multi_part;

import cool.scx.function.Function0;
import cool.scx.http.body.BodyAlreadyConsumedException;
import cool.scx.http.body.BodyReadException;
import cool.scx.http.body.ScxHttpBody;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.content_disposition.ContentDisposition;
import cool.scx.http.media.MediaReader;
import cool.scx.http.media.multi_part.MultiPartPartImpl;
import cool.scx.http.media.multi_part.MultiPartPartWritable;
import cool.scx.http.media_type.FileFormat;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.io.ByteInput;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;
import java.io.File;

public interface MultiPartPart
extends ScxHttpBody {
    public static MultiPartPartWritable of() {
        return new MultiPartPartImpl();
    }

    public static MultiPartPartWritable of(String name, String value) {
        return new MultiPartPartImpl().name(name).body(value);
    }

    public static MultiPartPartWritable of(String name, byte[] value) {
        return new MultiPartPartImpl().name(name).body(value);
    }

    public static MultiPartPartWritable of(String name, File value) {
        long fileSize = value.length();
        String filename = value.getName();
        FileFormat fileFormat = FileFormat.findByFileName(filename);
        MediaType contentType = fileFormat == null ? MediaType.APPLICATION_OCTET_STREAM : fileFormat.mediaType();
        return new MultiPartPartImpl().name(name).body(value).size(fileSize).filename(filename).contentType(contentType);
    }

    public ScxHttpHeaders headers();

    public Function0<ByteInput, ?> body();

    @Override
    default public ByteInput byteInput() throws ScxIOException {
        try {
            return (ByteInput)this.body().apply();
        }
        catch (Throwable e) {
            throw new ScxIOException(e);
        }
    }

    @Override
    default public <T> T as(MediaReader<T> mediaReader) throws BodyAlreadyConsumedException, BodyReadException {
        try {
            return mediaReader.read(this.byteInput(), this.headers());
        }
        catch (ScxIOException e) {
            throw new BodyReadException(e);
        }
        catch (AlreadyClosedException e) {
            throw new BodyAlreadyConsumedException();
        }
    }

    default public ScxMediaType contentType() {
        return this.headers().contentType();
    }

    default public ContentDisposition contentDisposition() {
        return this.headers().contentDisposition();
    }

    default public String name() {
        ContentDisposition contentDisposition = this.contentDisposition();
        return contentDisposition != null ? contentDisposition.name() : null;
    }

    default public String filename() {
        ContentDisposition contentDisposition = this.contentDisposition();
        return contentDisposition != null ? contentDisposition.filename() : null;
    }

    default public Long size() {
        ContentDisposition contentDisposition = this.contentDisposition();
        return contentDisposition != null ? contentDisposition.size() : null;
    }
}

