/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.multi_part;

import cool.scx.function.Function0;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.headers.content_disposition.ContentDisposition;
import cool.scx.http.media.multi_part.MultiPartPart;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.io.ByteInput;
import cool.scx.io.DefaultByteInput;
import cool.scx.io.supplier.ByteArrayByteSupplier;
import cool.scx.io.supplier.ByteSupplier;
import cool.scx.io.supplier.InputStreamByteSupplier;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public interface MultiPartPartWritable
extends MultiPartPart {
    @Override
    public ScxHttpHeadersWritable headers();

    public MultiPartPartWritable headers(ScxHttpHeaders var1);

    public MultiPartPartWritable body(Function0<ByteInput, ?> var1);

    default public MultiPartPartWritable contentType(ScxMediaType contentType) {
        this.headers().contentType(contentType);
        return this;
    }

    default public MultiPartPartWritable contentDisposition(ContentDisposition contentDisposition) {
        this.headers().contentDisposition(contentDisposition);
        return this;
    }

    default public MultiPartPartWritable name(String name) {
        ContentDisposition contentDisposition = this.headers().contentDisposition();
        if (contentDisposition != null) {
            this.contentDisposition(ContentDisposition.of(contentDisposition).name(name));
        } else {
            this.contentDisposition(ContentDisposition.of().type("form-data").name(name));
        }
        return this;
    }

    default public MultiPartPartWritable filename(String filename) {
        ContentDisposition contentDisposition = this.headers().contentDisposition();
        if (contentDisposition != null) {
            this.contentDisposition(ContentDisposition.of(contentDisposition).filename(filename));
        } else {
            this.contentDisposition(ContentDisposition.of().type("form-data").filename(filename));
        }
        return this;
    }

    default public MultiPartPartWritable size(long size) {
        ContentDisposition contentDisposition = this.headers().contentDisposition();
        if (contentDisposition != null) {
            this.contentDisposition(ContentDisposition.of(contentDisposition).size(size));
        } else {
            this.contentDisposition(ContentDisposition.of().type("form-data").size(size));
        }
        return this;
    }

    default public MultiPartPartWritable body(ByteInput os) {
        return this.body(() -> os);
    }

    default public MultiPartPartWritable body(InputStream os) {
        return this.body(() -> new DefaultByteInput((ByteSupplier)new InputStreamByteSupplier(os)));
    }

    default public MultiPartPartWritable body(byte[] os) {
        return this.body(() -> new DefaultByteInput((ByteSupplier)new ByteArrayByteSupplier((byte[][])new byte[][]{os})));
    }

    default public MultiPartPartWritable body(String os) {
        return this.body(() -> new DefaultByteInput((ByteSupplier)new ByteArrayByteSupplier((byte[][])new byte[][]{os.getBytes()})));
    }

    default public MultiPartPartWritable body(File os) {
        return this.body(() -> new DefaultByteInput((ByteSupplier)new InputStreamByteSupplier((InputStream)new FileInputStream(os))));
    }
}

