/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.multi_part;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.http.media.multi_part.MultiPartPart;
import cool.scx.http.media.multi_part.MultiPartPartImpl;
import cool.scx.io.ByteInput;
import cool.scx.io.DefaultByteInput;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;
import cool.scx.io.indexer.ByteIndexer;
import cool.scx.io.indexer.KMPByteIndexer;
import cool.scx.io.supplier.BoundaryByteSupplier;
import cool.scx.io.supplier.ByteSupplier;
import cool.scx.io.supplier.SpecialCloseByteSupplier;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MultiPartStream
implements MultiPart,
Iterator<MultiPartPart>,
AutoCloseable {
    private static final byte[] CRLF_CRLF_BYTES = "\r\n\r\n".getBytes();
    private final String boundary;
    private final byte[] boundaryBytes;
    private final byte[] boundaryStartBytes;
    private final ByteInput byteInput;
    private MultiPartPart lastPart;

    public MultiPartStream(ByteInput byteInput, String boundary) {
        this.boundary = boundary;
        this.boundaryBytes = ("--" + boundary).getBytes();
        this.boundaryStartBytes = ("\r\n--" + boundary).getBytes();
        this.byteInput = byteInput;
        this.lastPart = null;
    }

    public static void consumeByteInput(ByteInput byteInput) {
        try {
            ByteInput byteInput2 = byteInput;
            if (byteInput2 != null) {
                byteInput2.close();
            }
        }
        catch (AlreadyClosedException | ScxIOException throwable) {
            // empty catch block
        }
    }

    public ScxHttpHeadersWritable readHeaders() {
        byte[] headersBytes = this.byteInput.readUntil(CRLF_CRLF_BYTES);
        String headersStr = new String(headersBytes);
        return ScxHttpHeaders.ofStrict(headersStr);
    }

    public ByteInput readContent() {
        BoundaryByteSupplier boundaryByteSupplier = new BoundaryByteSupplier(this.byteInput, (ByteIndexer)new KMPByteIndexer(this.boundaryStartBytes), true);
        return new DefaultByteInput((ByteSupplier)SpecialCloseByteSupplier.noCloseDrain((ByteSupplier)boundaryByteSupplier));
    }

    @Override
    public String boundary() {
        return this.boundary;
    }

    @Override
    public Iterator<MultiPartPart> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        byte[] peek;
        if (this.lastPart != null) {
            MultiPartStream.consumeByteInput(this.lastPart.byteInput());
            this.byteInput.skipFully(2L);
            this.lastPart = null;
        }
        if ((peek = this.byteInput.peekFully(this.boundaryBytes.length + 2)).length != this.boundaryBytes.length + 2) {
            throw new RuntimeException("Malformed multipart: boundary peek too short");
        }
        for (int i = 0; i < this.boundaryBytes.length; ++i) {
            if (peek[i] == this.boundaryBytes[i]) continue;
            throw new RuntimeException("Malformed multipart: boundary not matched");
        }
        byte a = peek[peek.length - 2];
        byte b = peek[peek.length - 1];
        if (a == 45 && b == 45) {
            return false;
        }
        if (a == 13 && b == 10) {
            return true;
        }
        throw new RuntimeException("Malformed multipart: invalid boundary ending");
    }

    @Override
    public MultiPartPart next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more parts available.");
        }
        this.byteInput.skipFully((long)(this.boundaryBytes.length + 2));
        MultiPartPartImpl part = new MultiPartPartImpl();
        ScxHttpHeadersWritable headers = this.readHeaders();
        part.headers(headers);
        ByteInput content = this.readContent();
        part.body(content);
        this.lastPart = part;
        return part;
    }

    @Override
    public void close() throws ScxIOException, AlreadyClosedException {
        this.byteInput.close();
    }
}

