/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.multi_part;

import cool.scx.http.exception.BadRequestException;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.media.MediaReader;
import cool.scx.http.media.multi_part.MultiPartStream;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.io.ByteInput;

public class MultiPartStreamMediaReader
implements MediaReader<MultiPartStream> {
    public static final MultiPartStreamMediaReader MULTI_PART_STREAM_MEDIA_READER = new MultiPartStreamMediaReader();

    private MultiPartStreamMediaReader() {
    }

    public static String checkedBoundary(ScxHttpHeaders headers) {
        ScxMediaType contentType = headers.contentType();
        if (contentType == null) {
            throw new IllegalArgumentException("No Content-Type header found");
        }
        if (!MediaType.MULTIPART_FORM_DATA.equalsIgnoreParams(contentType)) {
            throw new IllegalArgumentException("Content-Type is not multipart/form-data");
        }
        String boundary = contentType.boundary();
        if (boundary == null) {
            throw new BadRequestException("No boundary found");
        }
        return boundary;
    }

    @Override
    public MultiPartStream read(ByteInput byteInput, ScxHttpHeaders headers) {
        String boundary = MultiPartStreamMediaReader.checkedBoundary(headers);
        return new MultiPartStream(byteInput, boundary);
    }
}

