/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.node;

import cool.scx.http.exception.BadRequestException;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.media.MediaReader;
import cool.scx.http.media.string.StringMediaReader;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.io.ByteInput;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;
import cool.scx.object.ScxObject;
import cool.scx.object.node.Node;
import cool.scx.object.parser.NodeParseException;

public class NodeMediaReader
implements MediaReader<Node> {
    public static final NodeMediaReader NODE_MEDIA_READER = new NodeMediaReader();

    private NodeMediaReader() {
    }

    @Override
    public Node read(ByteInput byteInput, ScxHttpHeaders requestHeaders) throws ScxIOException, AlreadyClosedException {
        String str = StringMediaReader.STRING_MEDIA_READER.read(byteInput, requestHeaders);
        ScxMediaType contentType = requestHeaders.contentType();
        if (MediaType.APPLICATION_JSON.equalsIgnoreParams(contentType)) {
            try {
                return ScxObject.fromJson((String)str);
            }
            catch (NodeParseException e) {
                throw new BadRequestException("JSON \u683c\u5f0f\u4e0d\u6b63\u786e !!!", (Throwable)e);
            }
        }
        if (MediaType.APPLICATION_XML.equalsIgnoreParams(contentType)) {
            try {
                return ScxObject.fromXml((String)str);
            }
            catch (NodeParseException e) {
                throw new BadRequestException("XML \u683c\u5f0f\u4e0d\u6b63\u786e !!!", (Throwable)e);
            }
        }
        try {
            return ScxObject.fromJson((String)str);
        }
        catch (NodeParseException exception) {
            try {
                return ScxObject.fromXml((String)str);
            }
            catch (NodeParseException e) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u8f6c\u6362\u4e3a JsonNode !!! : " + str);
            }
        }
    }
}

