/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.object;

import cool.scx.http.exception.BadRequestException;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.media.MediaReader;
import cool.scx.http.media.string.StringMediaReader;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.io.ByteInput;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;
import cool.scx.object.ScxObject;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.parser.NodeParseException;
import cool.scx.reflect.ScxReflect;
import cool.scx.reflect.TypeInfo;
import cool.scx.reflect.TypeReference;

public class ObjectMediaReader<T>
implements MediaReader<T> {
    private final TypeInfo type;

    public ObjectMediaReader(Class<T> clazz) {
        this.type = ScxReflect.typeOf(clazz);
    }

    public ObjectMediaReader(TypeReference<T> clazz) {
        this.type = ScxReflect.typeOf(clazz);
    }

    public ObjectMediaReader(TypeInfo clazz) {
        this.type = clazz;
    }

    @Override
    public T read(ByteInput byteInput, ScxHttpHeaders requestHeaders) throws ScxIOException, AlreadyClosedException {
        String str = StringMediaReader.STRING_MEDIA_READER.read(byteInput, requestHeaders);
        ScxMediaType contentType = requestHeaders.contentType();
        if (MediaType.APPLICATION_JSON.equalsIgnoreParams(contentType)) {
            try {
                return (T)ScxObject.fromJson((String)str, (TypeInfo)this.type);
            }
            catch (NodeMappingException | NodeParseException e) {
                throw new BadRequestException("JSON \u683c\u5f0f\u4e0d\u6b63\u786e !!!", e);
            }
        }
        if (MediaType.APPLICATION_XML.equalsIgnoreParams(contentType)) {
            try {
                return (T)ScxObject.fromXml((String)str, (TypeInfo)this.type);
            }
            catch (NodeMappingException | NodeParseException e) {
                throw new BadRequestException("XML \u683c\u5f0f\u4e0d\u6b63\u786e !!!", e);
            }
        }
        try {
            return (T)ScxObject.fromJson((String)str, (TypeInfo)this.type);
        }
        catch (Exception exception) {
            try {
                return (T)ScxObject.fromXml((String)str, (TypeInfo)this.type);
            }
            catch (NodeMappingException | NodeParseException e) {
                throw new IllegalArgumentException("\u65e0\u6cd5\u8f6c\u6362\u4e3a " + String.valueOf(this.type) + " !!! : " + str);
            }
        }
    }
}

