/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.object;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media.node.NodeHelper;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.io.ByteOutput;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;
import cool.scx.object.ScxObject;
import cool.scx.object.mapping.NodeMappingException;
import cool.scx.object.serializer.NodeSerializeException;
import java.nio.charset.StandardCharsets;

public class ObjectMediaWriter
implements MediaWriter {
    private final Object object;
    private byte[] data;

    public ObjectMediaWriter(Object object) {
        this.object = object;
        this.data = null;
    }

    @Override
    public long beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        block4: {
            ScxMediaType contentType = NodeHelper.trySetContentType(responseHeaders, requestHeaders);
            try {
                if (MediaType.APPLICATION_JSON.equalsIgnoreParams(contentType)) {
                    this.data = ScxObject.toJson((Object)this.object).getBytes(StandardCharsets.UTF_8);
                    break block4;
                }
                if (MediaType.APPLICATION_XML.equalsIgnoreParams(contentType)) {
                    this.data = ScxObject.toXml((Object)this.object).getBytes(StandardCharsets.UTF_8);
                    break block4;
                }
                throw new IllegalArgumentException("Unsupported media type: " + String.valueOf(contentType));
            }
            catch (NodeMappingException | NodeSerializeException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.data.length;
    }

    @Override
    public void write(ByteOutput byteOutput) throws ScxIOException, AlreadyClosedException {
        try (ByteOutput byteOutput2 = byteOutput;){
            byteOutput.write(this.data);
        }
    }
}

