/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.string;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.media.MediaReader;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.io.ByteInput;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class StringMediaReader
implements MediaReader<String> {
    public static final StringMediaReader STRING_MEDIA_READER = new StringMediaReader();
    private final Charset charset;

    public StringMediaReader(Charset charset) {
        this.charset = charset;
    }

    private StringMediaReader() {
        this.charset = null;
    }

    public static Charset getContentTypeCharsetOrUTF8(ScxHttpHeaders headers) {
        Charset charset;
        ScxMediaType contentType = headers.contentType();
        if (contentType != null && (charset = contentType.charset()) != null) {
            return charset;
        }
        return StandardCharsets.UTF_8;
    }

    @Override
    public String read(ByteInput byteInput, ScxHttpHeaders headers) throws ScxIOException, AlreadyClosedException {
        Charset c = this.charset != null ? this.charset : StringMediaReader.getContentTypeCharsetOrUTF8(headers);
        try (ByteInput byteInput2 = byteInput;){
            byte[] bytes = byteInput.readAll();
            String string = new String(bytes, c);
            return string;
        }
    }
}

