/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.media.string;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.http.media_type.MediaType;
import cool.scx.http.media_type.ScxMediaType;
import cool.scx.io.ByteOutput;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class StringMediaWriter
implements MediaWriter {
    private final Charset charset;
    private final String str;
    private byte[] bytes;

    public StringMediaWriter(String str) {
        this(str, StandardCharsets.UTF_8);
    }

    public StringMediaWriter(String str, Charset charset) {
        this.str = str;
        this.charset = charset;
        this.bytes = null;
    }

    @Override
    public long beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        if (responseHeaders.contentType() == null) {
            responseHeaders.contentType(ScxMediaType.of(MediaType.TEXT_PLAIN).charset(this.charset));
        }
        this.bytes = this.str.getBytes(this.charset);
        return this.bytes.length;
    }

    @Override
    public void write(ByteOutput byteOutput) throws ScxIOException, AlreadyClosedException {
        try (ByteOutput byteOutput2 = byteOutput;){
            byteOutput.write(this.bytes);
        }
    }
}

