/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.parameters;

import cool.scx.collections.multi_map.MultiMap;
import cool.scx.function.Function2Void;
import cool.scx.http.parameters.ParameterEntry;
import cool.scx.http.parameters.Parameters;
import cool.scx.http.parameters.ParametersIterator;
import cool.scx.http.parameters.ParametersWritable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParametersImpl<K, V>
implements ParametersWritable<K, V> {
    private final MultiMap<K, V> map = new MultiMap(LinkedHashMap::new, ArrayList::new);

    public ParametersImpl(Parameters<K, V> p) {
        this();
        for (ParameterEntry parameterEntry : p) {
            this.map.set(parameterEntry.name(), parameterEntry.values());
        }
    }

    public ParametersImpl() {
    }

    @Override
    public ParametersImpl<K, V> set(K name, V ... value) {
        this.map.set(name, (Object[])value);
        return this;
    }

    @Override
    public ParametersImpl<K, V> add(K name, V ... value) {
        this.map.add(name, (Object[])value);
        return this;
    }

    @Override
    public ParametersImpl<K, V> remove(K name) {
        this.map.removeAll(name);
        return this;
    }

    @Override
    public ParametersWritable<K, V> clear() {
        this.map.clear();
        return this;
    }

    @Override
    public long size() {
        return this.map.size();
    }

    @Override
    public Set<K> names() {
        return this.map.keys();
    }

    @Override
    public V get(K name) {
        return (V)this.map.get(name);
    }

    @Override
    public List<V> getAll(K name) {
        return this.map.getAll(name);
    }

    @Override
    public boolean contains(K name) {
        return this.map.containsKey(name);
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Map<K, List<V>> toMultiValueMap() {
        return this.map.toMultiValueMap();
    }

    @Override
    public Map<K, V> toMap() {
        return this.map.toSingleValueMap();
    }

    @Override
    public <X extends Throwable> void forEach(Function2Void<? super K, V, X> action) throws X {
        this.map.forEach(action);
    }

    @Override
    public <X extends Throwable> void forEachParameter(Function2Void<? super K, List<V>, X> action) throws X {
        this.map.forEachEntry(action);
    }

    @Override
    public Iterator<ParameterEntry<K, V>> iterator() {
        return new ParametersIterator(this.map.iterator());
    }

    public String toString() {
        return this.map.toString();
    }
}

