/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.http.sender;

import cool.scx.http.media.MediaWriter;
import cool.scx.http.media.byte_array.ByteArrayMediaWriter;
import cool.scx.http.media.byte_input.ByteInputMediaWriter;
import cool.scx.http.media.empty.EmptyMediaWriter;
import cool.scx.http.media.event_stream.ServerEventStream;
import cool.scx.http.media.event_stream.ServerEventStreamMediaWriter;
import cool.scx.http.media.file.FileMediaWriter;
import cool.scx.http.media.form_params.FormParams;
import cool.scx.http.media.form_params.FormParamsMediaWriter;
import cool.scx.http.media.input_stream.InputStreamMediaWriter;
import cool.scx.http.media.multi_part.MultiPart;
import cool.scx.http.media.multi_part.MultiPartMediaWriter;
import cool.scx.http.media.node.NodeMediaWriter;
import cool.scx.http.media.object.ObjectMediaWriter;
import cool.scx.http.media.string.StringMediaWriter;
import cool.scx.http.sender.BodyAlreadySentException;
import cool.scx.http.sender.GzipHttpSender;
import cool.scx.http.sender.HttpSendException;
import cool.scx.io.ByteInput;
import cool.scx.object.node.Node;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;

public interface ScxHttpSender<T> {
    public T send(MediaWriter var1) throws BodyAlreadySentException, HttpSendException;

    default public T send() throws HttpSendException, BodyAlreadySentException {
        return this.send(EmptyMediaWriter.EMPTY_MEDIA_WRITER);
    }

    default public T send(ByteInput byteInput) throws BodyAlreadySentException, HttpSendException {
        return this.send(new ByteInputMediaWriter(byteInput));
    }

    default public T send(InputStream inputStream) throws BodyAlreadySentException, HttpSendException {
        return this.send(new InputStreamMediaWriter(inputStream));
    }

    default public T send(byte[] bytes) throws BodyAlreadySentException, HttpSendException {
        return this.send(new ByteArrayMediaWriter(bytes));
    }

    default public T send(String str) throws BodyAlreadySentException, HttpSendException {
        return this.send(new StringMediaWriter(str));
    }

    default public T send(String str, Charset charset) throws BodyAlreadySentException, HttpSendException {
        return this.send(new StringMediaWriter(str, charset));
    }

    default public T send(File file) throws BodyAlreadySentException, HttpSendException {
        return this.send(new FileMediaWriter(file));
    }

    default public T send(File file, long offset, long length) throws BodyAlreadySentException, HttpSendException {
        return this.send(new FileMediaWriter(file, offset, length));
    }

    default public T send(FormParams formParams) throws BodyAlreadySentException, HttpSendException {
        return this.send(new FormParamsMediaWriter(formParams));
    }

    default public T send(MultiPart multiPart) throws BodyAlreadySentException, HttpSendException {
        return this.send(new MultiPartMediaWriter(multiPart));
    }

    default public T send(Node node) throws BodyAlreadySentException, HttpSendException {
        return this.send(new NodeMediaWriter(node));
    }

    default public T send(Object object) throws BodyAlreadySentException, HttpSendException {
        return this.send(new ObjectMediaWriter(object));
    }

    default public ServerEventStream sendEventStream() throws BodyAlreadySentException, HttpSendException {
        ServerEventStreamMediaWriter writer = new ServerEventStreamMediaWriter();
        this.send(writer);
        return writer.eventStream();
    }

    default public ScxHttpSender<T> sendGzip() {
        return new GzipHttpSender(this);
    }
}

