package cool.scx.http.media.form_params;

import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.headers.ScxHttpHeadersWritable;
import cool.scx.http.media.MediaWriter;
import cool.scx.io.ByteOutput;
import cool.scx.io.exception.AlreadyClosedException;
import cool.scx.io.exception.ScxIOException;

import static cool.scx.http.media_type.MediaType.APPLICATION_X_WWW_FORM_URLENCODED;
import static java.nio.charset.StandardCharsets.UTF_8;

/// FormParamsMediaWriter
///
/// @author scx567888
/// @version 0.0.1
public final class FormParamsMediaWriter implements MediaWriter {

    private final FormParams formParams;
    private byte[] bytes;

    public FormParamsMediaWriter(FormParams formParams) {
        this.formParams = formParams;
    }

    @Override
    public long beforeWrite(ScxHttpHeadersWritable responseHeaders, ScxHttpHeaders requestHeaders) {
        if (responseHeaders.contentType() == null) {
            responseHeaders.contentType(APPLICATION_X_WWW_FORM_URLENCODED);
        }
        bytes = formParams.encode().getBytes(UTF_8);
        return bytes.length;
    }

    @Override
    public void write(ByteOutput byteOutput) throws ScxIOException, AlreadyClosedException {
        try (byteOutput) {
            byteOutput.write(bytes);
        }
    }

}
