package cool.scx.http.media.multi_part;

import cool.scx.http.exception.BadRequestException;
import cool.scx.http.headers.ScxHttpHeaders;
import cool.scx.http.media.MediaReader;
import cool.scx.io.ByteInput;

import static cool.scx.http.media_type.MediaType.MULTIPART_FORM_DATA;

/// MultiPartStreamMediaReader
///
/// @author scx567888
/// @version 0.0.1
public final class MultiPartStreamMediaReader implements MediaReader<MultiPartStream> {

    public static final MultiPartStreamMediaReader MULTI_PART_STREAM_MEDIA_READER = new MultiPartStreamMediaReader();

    private MultiPartStreamMediaReader() {

    }

    public static String checkedBoundary(ScxHttpHeaders headers) {
        var contentType = headers.contentType();
        // 分块传输依赖 contentType 所以这里需要强制校验
        if (contentType == null) {
            // 这里 不抛出客户端异常 因为 这是用户调用的, 问题不能怪罪到客户端
            throw new IllegalArgumentException("No Content-Type header found");
        }
        if (!MULTIPART_FORM_DATA.equalsIgnoreParams(contentType)) {
            // 同上 这里 不抛出客户端异常 因为 这是用户调用的, 问题不能怪罪到客户端
            throw new IllegalArgumentException("Content-Type is not multipart/form-data");
        }
        var boundary = contentType.boundary();
        if (boundary == null) {
            // 当 Content-Type 已经是 MULTIPART_FORM_DATA 了 ,  boundary 是必须的 所以这里抛出客户端错误
            throw new BadRequestException("No boundary found");
        }
        return boundary;
    }

    @Override
    public MultiPartStream read(ByteInput byteInput, ScxHttpHeaders headers) {
        var boundary = checkedBoundary(headers);
        return new MultiPartStream(byteInput, boundary);
    }

}
