/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.common.util.ArrayUtils;
import cool.scx.io.DataReader;
import cool.scx.io.NoMatchFoundException;
import cool.scx.io.NoMoreDataException;
import java.io.IOException;
import java.io.OutputStream;

public class ByteArrayDataReader
implements DataReader {
    private final byte[] bytes;
    private int position;

    public ByteArrayDataReader(byte[] bytes) {
        this.bytes = bytes;
        this.position = 0;
    }

    @Override
    public byte read() throws NoMoreDataException {
        try {
            return this.bytes[this.position++];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoMoreDataException();
        }
    }

    @Override
    public byte[] read(int maxLength) throws NoMoreDataException {
        int availableLength = this.bytes.length - this.position;
        if (availableLength <= 0) {
            throw new NoMoreDataException();
        }
        int actualLength = Math.min(maxLength, availableLength);
        byte[] result = new byte[actualLength];
        System.arraycopy(this.bytes, this.position, result, 0, actualLength);
        this.position += actualLength;
        return result;
    }

    @Override
    public void read(OutputStream outputStream, int maxLength) throws NoMoreDataException {
        int availableLength = this.bytes.length - this.position;
        if (availableLength <= 0) {
            throw new NoMoreDataException();
        }
        int actualLength = Math.min(maxLength, availableLength);
        try {
            outputStream.write(this.bytes, this.position, actualLength);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to OutputStream", e);
        }
        this.position += actualLength;
    }

    @Override
    public byte peek() throws NoMoreDataException {
        try {
            return this.bytes[this.position];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoMoreDataException();
        }
    }

    @Override
    public byte[] peek(int maxLength) throws NoMoreDataException {
        int availableLength = this.bytes.length - this.position;
        if (availableLength <= 0) {
            throw new NoMoreDataException();
        }
        int actualLength = Math.min(maxLength, availableLength);
        byte[] result = new byte[actualLength];
        System.arraycopy(this.bytes, this.position, result, 0, actualLength);
        return result;
    }

    @Override
    public void peek(OutputStream outputStream, int maxLength) throws NoMoreDataException {
        int availableLength = this.bytes.length - this.position;
        if (availableLength <= 0) {
            throw new NoMoreDataException();
        }
        int actualLength = Math.min(maxLength, availableLength);
        try {
            outputStream.write(this.bytes, this.position, actualLength);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write to OutputStream", e);
        }
    }

    @Override
    public int indexOf(byte b) throws NoMatchFoundException {
        int index = ArrayUtils.indexOf((byte[])this.bytes, (int)this.position, (int)this.bytes.length, (byte)b);
        if (index == -1) {
            throw new NoMatchFoundException();
        }
        return index;
    }

    @Override
    public int indexOf(byte[] b) throws NoMatchFoundException {
        int index = ArrayUtils.indexOf((byte[])this.bytes, (int)this.position, (int)this.bytes.length, (byte[])b);
        if (index == -1) {
            throw new NoMatchFoundException();
        }
        return index;
    }

    @Override
    public void skip(int length) {
        this.position += length;
    }
}

