/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.function.Supplier;

public class InputStreamDataSupplier
implements Supplier<byte[]> {
    private static final int BUFFER_LENGTH = 8192;
    private final byte[] readBuffer;
    private final InputStream inputStream;

    public InputStreamDataSupplier(InputStream inputStream) {
        this.inputStream = inputStream;
        this.readBuffer = new byte[8192];
    }

    @Override
    public byte[] get() {
        try {
            int r = this.inputStream.read(this.readBuffer);
            if (r == -1) {
                return null;
            }
            return Arrays.copyOf(this.readBuffer, r);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

