/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.common.util.ArrayUtils;
import cool.scx.io.DataReader;
import cool.scx.io.Helper;
import cool.scx.io.NoMatchFoundException;
import cool.scx.io.NoMoreDataException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.function.Supplier;

public class LinkedDataReader
implements DataReader {
    private final Supplier<byte[]> bytesSupplier;
    private Node head;
    private Node tail;

    public LinkedDataReader(Supplier<byte[]> bytesSupplier) {
        this.bytesSupplier = bytesSupplier;
        this.tail = this.head = new Node(EMPTY_BYTES);
    }

    public boolean pullData() {
        byte[] bytes = this.bytesSupplier.get();
        if (bytes == null) {
            return false;
        }
        this.tail = this.tail.next = new Node(bytes);
        return true;
    }

    public void ensureAvailable() {
        while (!this.head.hasAvailable()) {
            boolean b;
            if (this.head.next == null && !(b = this.pullData())) {
                throw new NoMoreDataException();
            }
            this.head = this.head.next;
        }
    }

    @Override
    public byte read() throws NoMoreDataException {
        this.ensureAvailable();
        return this.head.bytes[this.head.position++];
    }

    @Override
    public byte[] read(int maxLength) throws NoMoreDataException {
        this.ensureAvailable();
        byte[] result = new byte[maxLength];
        int remaining = maxLength;
        Node n = this.head;
        while (remaining > 0) {
            boolean moreData;
            int toAdd = Math.min(remaining, n.available());
            System.arraycopy(n.bytes, n.position, result, maxLength - remaining, toAdd);
            n.position += toAdd;
            if ((remaining -= toAdd) <= 0) continue;
            if (n.next == null && !(moreData = this.pullData())) break;
            this.head = n = n.next;
        }
        return remaining == 0 ? result : Arrays.copyOf(result, maxLength - remaining);
    }

    @Override
    public void read(OutputStream outputStream, int maxLength) throws NoMoreDataException {
        this.ensureAvailable();
        int remaining = maxLength;
        Node n = this.head;
        while (remaining > 0) {
            boolean moreData;
            int toAdd = Math.min(remaining, n.available());
            try {
                outputStream.write(n.bytes, n.position, toAdd);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            n.position += toAdd;
            if ((remaining -= toAdd) <= 0) continue;
            if (n.next == null && !(moreData = this.pullData())) break;
            this.head = n = n.next;
        }
    }

    @Override
    public byte peek() throws NoMoreDataException {
        this.ensureAvailable();
        return this.head.bytes[this.head.position];
    }

    @Override
    public byte[] peek(int maxLength) throws NoMoreDataException {
        this.ensureAvailable();
        byte[] result = new byte[maxLength];
        int remaining = maxLength;
        Node n = this.head;
        while (remaining > 0) {
            boolean moreData;
            int toAdd = Math.min(remaining, n.available());
            System.arraycopy(n.bytes, n.position, result, maxLength - remaining, toAdd);
            if ((remaining -= toAdd) <= 0) continue;
            if (n.next == null && !(moreData = this.pullData())) break;
            n = n.next;
        }
        return remaining == 0 ? result : Arrays.copyOf(result, maxLength - remaining);
    }

    @Override
    public void peek(OutputStream outputStream, int maxLength) throws NoMoreDataException {
        this.ensureAvailable();
        byte[] result = new byte[maxLength];
        int remaining = maxLength;
        Node n = this.head;
        while (remaining > 0) {
            boolean moreData;
            int toAdd = Math.min(remaining, n.available());
            try {
                outputStream.write(n.bytes, n.position, toAdd);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if ((remaining -= toAdd) <= 0) continue;
            if (n.next == null && !(moreData = this.pullData())) break;
            n = n.next;
        }
    }

    @Override
    public int indexOf(byte b) throws NoMatchFoundException {
        int index = 0;
        Node n = this.head;
        while (n != null) {
            boolean moreData;
            int pos = ArrayUtils.indexOf((byte[])n.bytes, (int)n.position, (int)(n.bytes.length - n.position), (byte)b);
            if (pos != -1) {
                return index + (pos - n.position);
            }
            index += n.bytes.length - n.position;
            if (n.next == null && !(moreData = this.pullData())) break;
            n = n.next;
        }
        throw new NoMatchFoundException();
    }

    @Override
    public int indexOf(byte[] pattern) throws NoMatchFoundException {
        int index = 0;
        Node n = this.head;
        int[] lps = Helper.computeLPSArray(pattern);
        int patternIndex = 0;
        while (n != null) {
            boolean moreData;
            for (int i = n.position; i < n.bytes.length; ++i) {
                while (patternIndex > 0 && n.bytes[i] != pattern[patternIndex]) {
                    patternIndex = lps[patternIndex - 1];
                }
                if (n.bytes[i] == pattern[patternIndex]) {
                    ++patternIndex;
                }
                if (patternIndex != pattern.length) continue;
                return index + (i - n.position - patternIndex + 1);
            }
            index += n.bytes.length - n.position;
            if (n.next == null && !(moreData = this.pullData())) break;
            n = n.next;
        }
        throw new NoMatchFoundException();
    }

    @Override
    public void skip(int length) {
        this.ensureAvailable();
        int remaining = length;
        Node n = this.head;
        while (remaining > 0) {
            boolean moreData;
            int toAdd = Math.min(remaining, n.available());
            n.position += toAdd;
            if ((remaining -= toAdd) <= 0) continue;
            if (n.next == null && !(moreData = this.pullData())) break;
            this.head = n = n.next;
        }
    }

    private static class Node {
        private final byte[] bytes;
        private int position;
        private Node next;

        Node(byte[] bytes) {
            this.bytes = bytes;
        }

        int available() {
            return this.bytes.length - this.position;
        }

        boolean hasAvailable() {
            return this.position < this.bytes.length;
        }
    }
}

