/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.io.DataConsumer;
import cool.scx.io.IOHelper;
import java.util.ArrayList;
import java.util.List;

public class BytesDataConsumer
implements DataConsumer {
    private List<BytesInfo> resultList = null;
    private BytesInfo result = null;
    private int total = 0;

    @Override
    public void accept(byte[] bytes, int position, int length) {
        this.total += length;
        if (this.result == null) {
            this.result = new BytesInfo(bytes, position, length);
        } else {
            if (this.resultList == null) {
                this.resultList = new ArrayList<BytesInfo>();
                this.resultList.add(this.result);
            }
            this.resultList.add(new BytesInfo(bytes, position, length));
        }
    }

    public byte[] getBytes() {
        if (this.resultList == null) {
            if (this.result == null) {
                return new byte[0];
            }
            return IOHelper.compressBytes(this.result.bytes, this.result.position, this.result.length);
        }
        byte[] result = new byte[this.total];
        int offset = 0;
        for (BytesInfo b : this.resultList) {
            System.arraycopy(b.bytes, b.position, result, offset, b.length);
            offset += b.length;
        }
        return result;
    }

    private record BytesInfo(byte[] bytes, int position, int length) {
    }
}

