/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.common.util.ArrayUtils;
import cool.scx.io.BytesDataConsumer;
import cool.scx.io.DataConsumer;
import cool.scx.io.DataIndexer;
import cool.scx.io.DataReader;
import cool.scx.io.KMPDataIndexer;
import cool.scx.io.NoMatchFoundException;
import cool.scx.io.NoMoreDataException;
import java.util.function.Supplier;

public class LinkedDataReader
implements DataReader {
    private final Supplier<Node> dataSupplier;
    private Node head;
    private Node tail;

    public LinkedDataReader(Supplier<Node> dataSupplier) {
        this.dataSupplier = dataSupplier;
        this.tail = this.head = new Node(EMPTY_BYTES);
    }

    private boolean pullData() {
        Node data = this.dataSupplier.get();
        if (data == null) {
            return false;
        }
        this.tail = this.tail.next = data;
        return true;
    }

    private void ensureAvailable() {
        while (!this.head.hasAvailable()) {
            if (this.head.next == null && !this.pullData()) {
                throw new NoMoreDataException();
            }
            this.head = this.head.next;
        }
    }

    private void walk(DataConsumer consumer, int maxLength, boolean movePointer) {
        this.ensureAvailable();
        int remaining = maxLength;
        Node n = this.head;
        while (remaining > 0) {
            boolean success;
            int length = Math.min(remaining, n.available());
            consumer.accept(n.bytes, n.position, length);
            remaining -= length;
            if (movePointer) {
                n.position += length;
            }
            if (remaining <= 0) continue;
            if (n.next == null && !(success = this.pullData())) break;
            n = n.next;
            if (!movePointer) continue;
            this.head = n;
        }
    }

    private int indexOf(DataIndexer indexer) {
        int index = 0;
        Node n = this.head;
        while (true) {
            boolean success;
            int length;
            int i;
            if ((i = indexer.indexOf(n.bytes, n.position, length = n.available())) != -1) {
                return index + i;
            }
            index += length;
            if (n.next == null && !(success = this.pullData())) break;
            n = n.next;
        }
        throw new NoMatchFoundException();
    }

    @Override
    public byte read() throws NoMoreDataException {
        this.ensureAvailable();
        byte b = this.head.bytes[this.head.position];
        ++this.head.position;
        return b;
    }

    @Override
    public byte[] read(int maxLength) throws NoMoreDataException {
        BytesDataConsumer consumer = new BytesDataConsumer();
        this.walk(consumer, maxLength, true);
        return consumer.getBytes();
    }

    @Override
    public void read(DataConsumer dataConsumer, int maxLength) throws NoMoreDataException {
        this.walk(dataConsumer, maxLength, true);
    }

    @Override
    public byte peek() throws NoMoreDataException {
        this.ensureAvailable();
        return this.head.bytes[this.head.position];
    }

    @Override
    public byte[] peek(int maxLength) throws NoMoreDataException {
        BytesDataConsumer consumer = new BytesDataConsumer();
        this.walk(consumer, maxLength, false);
        return consumer.getBytes();
    }

    @Override
    public void peek(DataConsumer dataConsumer, int maxLength) throws NoMoreDataException {
        this.walk(dataConsumer, maxLength, false);
    }

    @Override
    public int indexOf(byte b) throws NoMatchFoundException {
        return this.indexOf((bytes, position, length) -> ArrayUtils.indexOf((byte[])bytes, (int)position, (int)length, (byte)b));
    }

    @Override
    public int indexOf(byte[] pattern) throws NoMatchFoundException {
        return this.indexOf(new KMPDataIndexer(pattern));
    }

    @Override
    public void skip(int length) {
        this.walk((byArray, n, n2) -> {}, length, true);
    }

    public static class Node {
        private final byte[] bytes;
        private final int limit;
        private int position;
        private Node next;

        public Node(byte[] bytes) {
            this.bytes = bytes;
            this.position = 0;
            this.limit = bytes.length;
        }

        public Node(byte[] bytes, int position, int limit) {
            this.bytes = bytes;
            this.position = position;
            this.limit = limit;
        }

        int available() {
            return this.limit - this.position;
        }

        boolean hasAvailable() {
            return this.position < this.limit;
        }

        public String toString() {
            return new String(this.bytes, this.position, this.limit - this.position);
        }
    }
}

