/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.zip;

import cool.scx.io.LazyInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterInputStream;

public class GzipBuilder
extends SequenceInputStream {
    public GzipBuilder(InputStream inputStream) {
        super(GzipBuilder.createGzipInputStream(inputStream));
    }

    public static Enumeration<InputStream> createGzipInputStream(InputStream inputStream) {
        CRC32 crc = new CRC32();
        Deflater def = new Deflater(-1, true);
        GzipHeaderInputStream headerInputStream = new GzipHeaderInputStream();
        GzipDataInputStream dataInputStream = new GzipDataInputStream(inputStream, crc, def);
        GzipTrailerInputStream trailerInputStream = new GzipTrailerInputStream(crc, def);
        List<GzipTrailerInputStream> in = List.of(headerInputStream, dataInputStream, trailerInputStream);
        return Collections.enumeration(in);
    }

    public static class GzipHeaderInputStream
    extends ByteArrayInputStream {
        private static final int GZIP_MAGIC = 35615;
        private static final byte OS_UNKNOWN = -1;
        private static final byte[] HEADER = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, -1};

        public GzipHeaderInputStream() {
            super(HEADER);
        }
    }

    public static class GzipDataInputStream
    extends DeflaterInputStream {
        public GzipDataInputStream(InputStream in, CRC32 crc, Deflater def) {
            super(new CheckedInputStream(in, crc), def);
        }
    }

    public static class GzipTrailerInputStream
    extends LazyInputStream {
        private static final int TRAILER_SIZE = 8;
        private final CRC32 crc;
        private final Deflater def;

        public GzipTrailerInputStream(CRC32 crc, Deflater def) {
            this.crc = crc;
            this.def = def;
        }

        @Override
        public InputStream toInputStream0() {
            byte[] trailer = new byte[8];
            this.writeTrailer(trailer, 0);
            return new ByteArrayInputStream(trailer);
        }

        private void writeTrailer(byte[] buf, int offset) {
            this.writeInt((int)this.crc.getValue(), buf, offset);
            int iSize = (int)this.def.getBytesRead();
            this.writeInt(iSize, buf, offset + 4);
        }

        private void writeInt(int i, byte[] buf, int offset) {
            this.writeShort(i & 0xFFFF, buf, offset);
            this.writeShort(i >> 16 & 0xFFFF, buf, offset + 2);
        }

        private void writeShort(int s, byte[] buf, int offset) {
            buf[offset] = (byte)(s & 0xFF);
            buf[offset + 1] = (byte)(s >> 8 & 0xFF);
        }
    }
}

