/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.common.util.ArrayUtils;
import cool.scx.io.BytesDataConsumer;
import cool.scx.io.DataConsumer;
import cool.scx.io.DataIndexer;
import cool.scx.io.DataNode;
import cool.scx.io.DataReader;
import cool.scx.io.KMPDataIndexer;
import cool.scx.io.NoMatchFoundException;
import cool.scx.io.NoMoreDataException;
import java.util.function.Supplier;

public class LinkedDataReader
implements DataReader {
    private final Supplier<DataNode> dataSupplier;
    private DataNode head;
    private DataNode tail;

    public LinkedDataReader(Supplier<DataNode> dataSupplier) {
        this.dataSupplier = dataSupplier;
        this.tail = this.head = new DataNode(EMPTY_BYTES);
    }

    private boolean pullData() {
        DataNode data = this.dataSupplier.get();
        if (data == null) {
            return false;
        }
        this.tail = this.tail.next = data;
        return true;
    }

    private void ensureAvailable() throws NoMoreDataException {
        while (!this.head.hasAvailable()) {
            if (this.head.next == null && !this.pullData()) {
                throw new NoMoreDataException();
            }
            this.head = this.head.next;
        }
    }

    private void walk(DataConsumer consumer, int maxLength, boolean movePointer) throws NoMoreDataException {
        this.ensureAvailable();
        int remaining = maxLength;
        DataNode n = this.head;
        while (remaining > 0) {
            boolean success;
            int length = Math.min(remaining, n.available());
            consumer.accept(n.bytes, n.position, length);
            remaining -= length;
            if (movePointer) {
                n.position += length;
            }
            if (remaining <= 0) continue;
            if (n.next == null && !(success = this.pullData())) break;
            n = n.next;
            if (!movePointer) continue;
            this.head = n;
        }
    }

    private int indexOf(DataIndexer indexer, int max) throws NoMoreDataException, NoMatchFoundException {
        this.ensureAvailable();
        int index = 0;
        DataNode n = this.head;
        while (true) {
            boolean success;
            int length;
            int i;
            if ((i = indexer.indexOf(n.bytes, n.position, length = Math.min(n.available(), max - index))) != Integer.MIN_VALUE) {
                return index + i;
            }
            if ((index += length) >= max || n.next == null && !(success = this.pullData())) break;
            n = n.next;
        }
        throw new NoMatchFoundException();
    }

    @Override
    public byte read() throws NoMoreDataException {
        this.ensureAvailable();
        byte b = this.head.bytes[this.head.position];
        ++this.head.position;
        return b;
    }

    @Override
    public byte[] read(int maxLength) throws NoMoreDataException {
        BytesDataConsumer consumer = new BytesDataConsumer();
        this.walk(consumer, maxLength, true);
        return consumer.getBytes();
    }

    @Override
    public void read(DataConsumer dataConsumer, int maxLength) throws NoMoreDataException {
        this.walk(dataConsumer, maxLength, true);
    }

    @Override
    public byte peek() throws NoMoreDataException {
        this.ensureAvailable();
        return this.head.bytes[this.head.position];
    }

    @Override
    public byte[] peek(int maxLength) throws NoMoreDataException {
        BytesDataConsumer consumer = new BytesDataConsumer();
        this.walk(consumer, maxLength, false);
        return consumer.getBytes();
    }

    @Override
    public void peek(DataConsumer dataConsumer, int maxLength) throws NoMoreDataException {
        this.walk(dataConsumer, maxLength, false);
    }

    @Override
    public int indexOf(byte b, int max) throws NoMatchFoundException, NoMoreDataException {
        return this.indexOf((bytes, position, length) -> {
            int i = ArrayUtils.indexOf((byte[])bytes, (int)position, (int)length, (byte)b);
            return i == -1 ? Integer.MIN_VALUE : i;
        }, max);
    }

    @Override
    public int indexOf(byte[] pattern, int max) throws NoMatchFoundException, NoMoreDataException {
        return this.indexOf(new KMPDataIndexer(pattern), max);
    }

    @Override
    public void skip(int length) throws NoMoreDataException {
        this.walk((byArray, n, n2) -> {}, length, true);
    }
}

