/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.file;

import cool.scx.io.file.FileWatcher;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FileAttributesReader {
    private static final NotExist NOT_EXIST = new NotExist();
    private final Path target;
    private final FileWatcher fileWatcher;
    private final Map<Path, BasicFileAttributes> cache;

    public FileAttributesReader(Path target) throws IOException {
        this.target = target;
        this.fileWatcher = new FileWatcher(target).listener(this::onChange).start();
        this.cache = new ConcurrentHashMap<Path, BasicFileAttributes>();
    }

    private void onChange(FileWatcher.ChangeEvent event) {
        try {
            if (event.type() == FileWatcher.ChangeEventType.DELETED) {
                this.cache.put(event.target(), NOT_EXIST);
            } else {
                this.cache.put(event.target(), Files.readAttributes(event.target(), BasicFileAttributes.class, new LinkOption[0]));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BasicFileAttributes get(Path path) throws IOException {
        BasicFileAttributes f = this.cache.computeIfAbsent(path, c -> {
            try {
                return Files.readAttributes(c, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (NoSuchFileException e) {
                return NOT_EXIST;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        if (f == NOT_EXIST) {
            return null;
        }
        return f;
    }

    private static class NotExist
    implements BasicFileAttributes {
        private NotExist() {
        }

        @Override
        public FileTime lastModifiedTime() {
            return null;
        }

        @Override
        public FileTime lastAccessTime() {
            return null;
        }

        @Override
        public FileTime creationTime() {
            return null;
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isSymbolicLink() {
            return false;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public Object fileKey() {
            return null;
        }
    }
}

