/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public final class IOHelper {
    public static long getFileSize(Path path) {
        try {
            return Files.size(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static byte[] compressBytes(byte[] bytes, int offset, int length) {
        if (offset == 0 && length == bytes.length) {
            return bytes;
        }
        byte[] data = new byte[length];
        System.arraycopy(bytes, offset, data, 0, length);
        return data;
    }

    public static void writeFileToOut(Path path, OutputStream out) throws IOException {
        try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
            inputStream.transferTo(out);
        }
    }

    public static void writeFileToOut(Path path, OutputStream out, long offset, long length) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(path.toFile(), "r");){
            raf.seek(offset);
            byte[] buffer = new byte[8192];
            while (length > 0L) {
                int i = raf.read(buffer, 0, (int)Math.min((long)buffer.length, length));
                if (i == -1) {
                    break;
                }
                out.write(buffer, 0, i);
                length -= (long)i;
            }
        }
    }

    public static void readInToFile(InputStream in, Path path, OpenOption ... options) throws IOException {
        try (OutputStream os = Files.newOutputStream(path, options);){
            in.transferTo(os);
        }
    }

    public static void readInToFile(InputStream in, Path path, long offset, long length) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(path.toFile(), "rw");){
            raf.seek(offset);
            byte[] buffer = new byte[8192];
            while (length > 0L) {
                int i = in.read(buffer);
                if (i == -1) {
                    break;
                }
                raf.write(buffer, 0, i);
                length -= (long)i;
            }
        }
    }

    public static int transferByteBuffer(ByteBuffer source, ByteBuffer dest) {
        int destRemaining;
        int sourceRemaining = source.remaining();
        if (sourceRemaining > (destRemaining = dest.remaining())) {
            int originalLimit = source.limit();
            source.limit(source.position() + destRemaining);
            dest.put(source);
            source.limit(originalLimit);
            return destRemaining;
        }
        dest.put(source);
        return sourceRemaining;
    }
}

