/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.io.DataSupplier;
import cool.scx.io.FillByteArrayDataConsumer;
import cool.scx.io.FillByteBufferDataConsumer;
import cool.scx.io.KMPDataIndexer;
import cool.scx.io.LinkedDataReader;
import cool.scx.io.NoMatchFoundException;
import cool.scx.io.NoMoreDataException;
import cool.scx.io.OutputStreamDataConsumer;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class PowerfulLinkedDataReader
extends LinkedDataReader {
    public PowerfulLinkedDataReader(DataSupplier dataSupplier) {
        super(dataSupplier);
    }

    public PowerfulLinkedDataReader() {
    }

    public int inputStreamRead() throws NoMoreDataException {
        boolean r = this.ensureAvailable();
        if (!r) {
            return -1;
        }
        byte b = this.head.bytes[this.head.position];
        ++this.head.position;
        return b;
    }

    public int inputStreamRead(byte[] b, int off, int len) throws NoMoreDataException {
        boolean r = this.ensureAvailable();
        if (!r) {
            return -1;
        }
        FillByteArrayDataConsumer consumer = new FillByteArrayDataConsumer(b, off, len);
        this.walk(consumer, len, true);
        return consumer.getFilledLength();
    }

    public long inputStreamTransferTo(OutputStream out) throws NoMoreDataException {
        boolean r = this.ensureAvailable();
        if (!r) {
            return -1L;
        }
        OutputStreamDataConsumer consumer = new OutputStreamDataConsumer(out);
        this.walk(consumer, Long.MAX_VALUE, true);
        return consumer.byteCount();
    }

    public int byteChannelRead(ByteBuffer b) throws NoMoreDataException {
        boolean r = this.ensureAvailable();
        if (!r) {
            return -1;
        }
        FillByteBufferDataConsumer consumer = new FillByteBufferDataConsumer(b);
        this.walk(consumer, b.remaining(), true);
        return consumer.getFilledLength();
    }

    public byte[] readUntil(KMPDataIndexer indexer, int max) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(indexer, (long)max);
        byte[] data = this.read(Math.toIntExact(index));
        this.skip(indexer.pattern().length);
        return data;
    }

    public byte[] readUntil(KMPDataIndexer indexer) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(indexer, Long.MAX_VALUE);
        byte[] data = this.read(Math.toIntExact(index));
        this.skip(indexer.pattern().length);
        return data;
    }

    public byte[] peekUntil(KMPDataIndexer indexer, int max) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(indexer, (long)max);
        return this.peek(Math.toIntExact(index));
    }

    public byte[] peekUntil(KMPDataIndexer indexer) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(indexer, Long.MAX_VALUE);
        return this.peek(Math.toIntExact(index));
    }

    public long indexOf(KMPDataIndexer indexer, long max) throws NoMatchFoundException, NoMoreDataException {
        this.ensureAvailableOrThrow();
        indexer.reset();
        return super.indexOf(indexer, max);
    }
}

