/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.io.DataNode;
import cool.scx.io.DataSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;

public class BufferedInputStreamDataSupplier
implements DataSupplier {
    private final InputStream inputStream;
    private final byte[] buffer;

    public BufferedInputStreamDataSupplier(InputStream inputStream, int bufferLength) {
        this.inputStream = inputStream;
        this.buffer = new byte[bufferLength];
    }

    public BufferedInputStreamDataSupplier(InputStream inputStream) {
        this(inputStream, 8192);
    }

    @Override
    public DataNode get() {
        try {
            int i = this.inputStream.read(this.buffer);
            if (i == -1) {
                return null;
            }
            byte[] data = new byte[i];
            System.arraycopy(this.buffer, 0, data, 0, i);
            return new DataNode(data);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

