/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.io.PowerfulLinkedDataReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FixedLengthDataReaderInputStream
extends InputStream {
    private final PowerfulLinkedDataReader dataReader;
    private final long maxLength;
    private long position;

    public FixedLengthDataReaderInputStream(PowerfulLinkedDataReader dataReader, long maxLength) {
        this.dataReader = dataReader;
        this.maxLength = maxLength;
        this.position = 0L;
    }

    @Override
    public int read() {
        if (this.position >= this.maxLength) {
            return -1;
        }
        int i = this.dataReader.inputStreamRead();
        return this.movePosition(i);
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this.position >= this.maxLength) {
            return -1;
        }
        long length = Math.min((long)len, this.maxLength - this.position);
        int i = this.dataReader.inputStreamRead(b, off, (int)length);
        return this.movePosition(i);
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        if (this.position >= this.maxLength) {
            return -1L;
        }
        long length = this.maxLength - this.position;
        long i = this.dataReader.inputStreamTransferTo(out, length);
        return this.movePosition(i);
    }

    private int movePosition(int i) {
        if (i == -1) {
            return -1;
        }
        this.position += (long)i;
        return i;
    }

    private long movePosition(long i) {
        if (i == -1L) {
            return -1L;
        }
        this.position += i;
        return i;
    }
}

