/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.io.DataIndexer;

public class KMPDataIndexer
implements DataIndexer {
    private final int[] lps;
    private final byte[] pattern;
    private int patternIndex;

    public KMPDataIndexer(byte[] pattern) {
        this.pattern = pattern;
        this.patternIndex = 0;
        this.lps = KMPDataIndexer.computeLPSArray(pattern);
    }

    public static int[] computeLPSArray(byte[] pattern) {
        int[] lps = new int[pattern.length];
        int length = 0;
        int i = 1;
        while (i < pattern.length) {
            if (pattern[i] == pattern[length]) {
                lps[i] = ++length;
                ++i;
                continue;
            }
            if (length != 0) {
                length = lps[length - 1];
                continue;
            }
            lps[i] = 0;
            ++i;
        }
        return lps;
    }

    @Override
    public int indexOf(byte[] bytes, int position, int length) {
        int end = position + length;
        for (int i = position; i < end; ++i) {
            while (this.patternIndex > 0 && bytes[i] != this.pattern[this.patternIndex]) {
                this.patternIndex = this.lps[this.patternIndex - 1];
            }
            if (bytes[i] == this.pattern[this.patternIndex]) {
                ++this.patternIndex;
            }
            if (this.patternIndex != this.pattern.length) continue;
            int result = i - position - this.patternIndex + 1;
            this.patternIndex = 0;
            return result;
        }
        return Integer.MIN_VALUE;
    }

    public void reset() {
        this.patternIndex = 0;
    }

    public byte[] pattern() {
        return this.pattern;
    }
}

