/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io;

import cool.scx.io.ByteArrayDataConsumer;
import cool.scx.io.ByteIndexer;
import cool.scx.io.DataConsumer;
import cool.scx.io.DataIndexer;
import cool.scx.io.DataNode;
import cool.scx.io.DataReader;
import cool.scx.io.DataSupplier;
import cool.scx.io.KMPDataIndexer;
import cool.scx.io.NoMatchFoundException;
import cool.scx.io.NoMoreDataException;
import cool.scx.io.SkipDataConsumer;

public class LinkedDataReader
implements DataReader {
    public final DataSupplier dataSupplier;
    public DataNode head;
    public DataNode tail;

    public LinkedDataReader(DataSupplier dataSupplier) {
        this.dataSupplier = dataSupplier;
        this.tail = this.head = new DataNode(new byte[0]);
    }

    public LinkedDataReader() {
        this(() -> null);
    }

    public void appendData(DataNode data) {
        this.tail = this.tail.next = data;
    }

    public boolean pullData() {
        DataNode data = this.dataSupplier.get();
        if (data == null) {
            return false;
        }
        this.appendData(data);
        return true;
    }

    public boolean ensureAvailable() {
        while (!this.head.hasAvailable()) {
            boolean result;
            if (this.head.next == null && !(result = this.pullData())) {
                return false;
            }
            this.head = this.head.next;
        }
        return true;
    }

    public void ensureAvailableOrThrow() throws NoMoreDataException {
        boolean b = this.ensureAvailable();
        if (!b) {
            throw new NoMoreDataException();
        }
    }

    public void walk(DataConsumer consumer, long maxLength, boolean movePointer) {
        long remaining = maxLength;
        DataNode n = this.head;
        while (remaining > 0L) {
            boolean result;
            int length = (int)Math.min(remaining, (long)n.available());
            consumer.accept(n.bytes, n.position, length);
            remaining -= (long)length;
            if (movePointer) {
                n.position += length;
            }
            if (remaining <= 0L) continue;
            if (n.next == null && !(result = this.pullData())) break;
            n = n.next;
            if (!movePointer) continue;
            this.head = n;
        }
    }

    public long indexOf(DataIndexer indexer, long max) throws NoMatchFoundException {
        long index = 0L;
        DataNode n = this.head;
        while (true) {
            boolean result;
            int length;
            int i;
            if ((i = indexer.indexOf(n.bytes, n.position, length = (int)Math.min((long)n.available(), max - index))) != Integer.MIN_VALUE) {
                return index + (long)i;
            }
            if ((index += (long)length) >= max || n.next == null && !(result = this.pullData())) break;
            n = n.next;
        }
        throw new NoMatchFoundException();
    }

    @Override
    public byte read() throws NoMoreDataException {
        this.ensureAvailableOrThrow();
        byte b = this.head.bytes[this.head.position];
        ++this.head.position;
        return b;
    }

    @Override
    public byte[] read(int maxLength) throws NoMoreDataException {
        if (maxLength > 0) {
            this.ensureAvailableOrThrow();
        }
        ByteArrayDataConsumer consumer = new ByteArrayDataConsumer();
        this.walk(consumer, maxLength, true);
        return consumer.getBytes();
    }

    @Override
    public void read(DataConsumer dataConsumer, long maxLength) throws NoMoreDataException {
        if (maxLength > 0L) {
            this.ensureAvailableOrThrow();
        }
        this.walk(dataConsumer, maxLength, true);
    }

    @Override
    public byte peek() throws NoMoreDataException {
        this.ensureAvailableOrThrow();
        return this.head.bytes[this.head.position];
    }

    @Override
    public byte[] peek(int maxLength) throws NoMoreDataException {
        if (maxLength > 0) {
            this.ensureAvailableOrThrow();
        }
        ByteArrayDataConsumer consumer = new ByteArrayDataConsumer();
        this.walk(consumer, maxLength, false);
        return consumer.getBytes();
    }

    @Override
    public void peek(DataConsumer dataConsumer, long maxLength) throws NoMoreDataException {
        if (maxLength > 0L) {
            this.ensureAvailableOrThrow();
        }
        this.walk(dataConsumer, maxLength, false);
    }

    @Override
    public long indexOf(byte b, long maxLength) throws NoMatchFoundException, NoMoreDataException {
        if (maxLength > 0L) {
            this.ensureAvailableOrThrow();
        }
        return this.indexOf(new ByteIndexer(b), maxLength);
    }

    @Override
    public long indexOf(byte[] pattern, long maxLength) throws NoMatchFoundException, NoMoreDataException {
        if (maxLength > 0L) {
            this.ensureAvailableOrThrow();
        }
        return this.indexOf(new KMPDataIndexer(pattern), maxLength);
    }

    @Override
    public void skip(long length) throws NoMoreDataException {
        if (length > 0L) {
            this.ensureAvailableOrThrow();
        }
        this.walk(SkipDataConsumer.SKIP_DATA_CONSUMER, length, true);
    }
}

