/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.io_stream;

import cool.scx.io.data_reader.PowerfulLinkedDataReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FixedLengthDataReaderInputStream
extends InputStream {
    private final PowerfulLinkedDataReader dataReader;
    private final long maxLength;
    private long position;

    public FixedLengthDataReaderInputStream(PowerfulLinkedDataReader dataReader, long maxLength) {
        this.dataReader = dataReader;
        this.maxLength = maxLength;
        this.position = 0L;
    }

    @Override
    public int read() {
        if (this.position >= this.maxLength) {
            return -1;
        }
        int i = this.dataReader.inputStreamRead();
        if (i == -1) {
            this.position = this.maxLength;
            return -1;
        }
        ++this.position;
        return i;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (this.position >= this.maxLength) {
            return -1;
        }
        long length = Math.min((long)len, this.maxLength - this.position);
        int i = this.dataReader.inputStreamRead(b, off, (int)length);
        if (i == -1) {
            this.position = this.maxLength;
            return -1;
        }
        this.position += (long)i;
        return i;
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        if (this.position >= this.maxLength) {
            return -1L;
        }
        long length = this.maxLength - this.position;
        long i = this.dataReader.inputStreamTransferTo(out, length);
        if (i == -1L) {
            this.position = this.maxLength;
            return -1L;
        }
        this.position += i;
        return i;
    }
}

