/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.data_consumer;

import cool.scx.io.data_consumer.DataConsumer;
import java.nio.ByteBuffer;

public class FillByteBufferDataConsumer
implements DataConsumer {
    private final ByteBuffer data;
    private final int dataPosition;

    public FillByteBufferDataConsumer(ByteBuffer data) {
        this.data = data;
        this.dataPosition = data.position();
    }

    @Override
    public void accept(byte[] bytes, int position, int length) {
        if (this.data.remaining() < length) {
            throw new IllegalStateException("Buffer overflow: not enough space to accept more data");
        }
        this.data.put(bytes, position, length);
    }

    public int getFilledLength() {
        return this.data.position() - this.dataPosition;
    }
}

