/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.io_stream;

import cool.scx.io.data_reader.PowerfulLinkedDataReader;
import cool.scx.io.data_supplier.DataSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DataReaderInputStream
extends InputStream {
    private final PowerfulLinkedDataReader dataReader;
    private volatile boolean closed;

    public DataReaderInputStream(PowerfulLinkedDataReader dataReader) {
        this.dataReader = dataReader;
    }

    public DataReaderInputStream(DataSupplier dataSupplier) {
        this.dataReader = new PowerfulLinkedDataReader(dataSupplier);
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.dataReader.inputStreamRead();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        return this.dataReader.inputStreamRead(b, off, len);
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        this.ensureOpen();
        return this.dataReader.inputStreamTransferTo(out);
    }

    public PowerfulLinkedDataReader dataReader() {
        return this.dataReader;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

