/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.data_reader;

import cool.scx.common.util.ArrayUtils;
import cool.scx.io.data_consumer.DataConsumer;
import cool.scx.io.data_reader.DataReader;
import cool.scx.io.exception.NoMatchFoundException;
import cool.scx.io.exception.NoMoreDataException;

public class ByteArrayDataReader
implements DataReader {
    private final byte[] bytes;
    private int position;

    public ByteArrayDataReader(byte[] bytes) {
        this.bytes = bytes;
        this.position = 0;
    }

    @Override
    public byte read() throws NoMoreDataException {
        try {
            byte b = this.bytes[this.position];
            ++this.position;
            return b;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoMoreDataException();
        }
    }

    @Override
    public byte[] read(int maxLength) throws NoMoreDataException {
        int availableLength = this.bytes.length - this.position;
        if (availableLength <= 0) {
            throw new NoMoreDataException();
        }
        int actualLength = Math.min(maxLength, availableLength);
        byte[] result = new byte[actualLength];
        System.arraycopy(this.bytes, this.position, result, 0, actualLength);
        this.position += actualLength;
        return result;
    }

    @Override
    public void read(DataConsumer dataConsumer, long maxLength) throws NoMoreDataException {
        int availableLength = this.bytes.length - this.position;
        if (availableLength <= 0) {
            throw new NoMoreDataException();
        }
        int actualLength = (int)Math.min(maxLength, (long)availableLength);
        dataConsumer.accept(this.bytes, this.position, actualLength);
        this.position += actualLength;
    }

    @Override
    public byte peek() throws NoMoreDataException {
        try {
            return this.bytes[this.position];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoMoreDataException();
        }
    }

    @Override
    public byte[] peek(int maxLength) throws NoMoreDataException {
        int availableLength = this.bytes.length - this.position;
        if (availableLength <= 0) {
            throw new NoMoreDataException();
        }
        int actualLength = Math.min(maxLength, availableLength);
        byte[] result = new byte[actualLength];
        System.arraycopy(this.bytes, this.position, result, 0, actualLength);
        return result;
    }

    @Override
    public void peek(DataConsumer dataConsumer, long maxLength) throws NoMoreDataException {
        int availableLength = this.bytes.length - this.position;
        if (availableLength <= 0) {
            throw new NoMoreDataException();
        }
        int actualLength = (int)Math.min(maxLength, (long)availableLength);
        dataConsumer.accept(this.bytes, this.position, actualLength);
    }

    @Override
    public long indexOf(byte b, long maxLength) throws NoMatchFoundException, NoMoreDataException {
        int availableLength = this.bytes.length - this.position;
        if (availableLength <= 0) {
            throw new NoMoreDataException();
        }
        int index = ArrayUtils.indexOf((byte[])this.bytes, (int)this.position, (int)((int)Math.min((long)this.bytes.length, maxLength)), (byte)b);
        if (index == -1) {
            throw new NoMatchFoundException();
        }
        return index;
    }

    @Override
    public long indexOf(byte[] b, long maxLength) throws NoMatchFoundException, NoMoreDataException {
        int availableLength = this.bytes.length - this.position;
        if (availableLength <= 0) {
            throw new NoMoreDataException();
        }
        int index = ArrayUtils.indexOf((byte[])this.bytes, (int)this.position, (int)((int)Math.min((long)this.bytes.length, maxLength)), (byte[])b);
        if (index == -1) {
            throw new NoMatchFoundException();
        }
        return index;
    }

    @Override
    public void skip(long length) throws NoMoreDataException {
        int availableLength = this.bytes.length - this.position;
        if (availableLength <= 0) {
            throw new NoMoreDataException();
        }
        this.position = length >= (long)availableLength ? this.bytes.length : (this.position += (int)length);
    }
}

