/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.data_reader;

import cool.scx.io.data_consumer.DataConsumer;
import cool.scx.io.exception.NoMatchFoundException;
import cool.scx.io.exception.NoMoreDataException;

public interface DataReader {
    public byte read() throws NoMoreDataException;

    public byte[] read(int var1) throws NoMoreDataException;

    public void read(DataConsumer var1, long var2) throws NoMoreDataException;

    public byte peek() throws NoMoreDataException;

    public byte[] peek(int var1) throws NoMoreDataException;

    public void peek(DataConsumer var1, long var2) throws NoMoreDataException;

    public long indexOf(byte var1, long var2) throws NoMatchFoundException, NoMoreDataException;

    public long indexOf(byte[] var1, long var2) throws NoMatchFoundException, NoMoreDataException;

    public void skip(long var1) throws NoMoreDataException;

    default public long indexOf(byte b) throws NoMatchFoundException, NoMoreDataException {
        return this.indexOf(b, Long.MAX_VALUE);
    }

    default public long indexOf(byte[] b) throws NoMatchFoundException, NoMoreDataException {
        return this.indexOf(b, Long.MAX_VALUE);
    }

    default public byte[] readUntil(byte b, int maxLength) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(b, (long)maxLength);
        byte[] data = this.read(Math.toIntExact(index));
        this.skip(1L);
        return data;
    }

    default public byte[] readUntil(byte[] b, int maxLength) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(b, (long)maxLength);
        byte[] data = this.read(Math.toIntExact(index));
        this.skip(b.length);
        return data;
    }

    default public byte[] peekUntil(byte b, int maxLength) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(b, (long)maxLength);
        return this.peek(Math.toIntExact(index));
    }

    default public byte[] peekUntil(byte[] b, int maxLength) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(b, (long)maxLength);
        return this.peek(Math.toIntExact(index));
    }

    default public byte[] readUntil(byte b) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(b);
        byte[] data = this.read(Math.toIntExact(index));
        this.skip(1L);
        return data;
    }

    default public byte[] readUntil(byte[] b) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(b);
        byte[] data = this.read(Math.toIntExact(index));
        this.skip(b.length);
        return data;
    }

    default public byte[] peekUntil(byte b) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(b);
        return this.peek(Math.toIntExact(index));
    }

    default public byte[] peekUntil(byte[] b) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(b);
        return this.peek(Math.toIntExact(index));
    }
}

