/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.data_reader;

import cool.scx.io.data_consumer.FillByteArrayDataConsumer;
import cool.scx.io.data_consumer.OutputStreamDataConsumer;
import cool.scx.io.data_reader.LinkedDataReader;
import cool.scx.io.data_supplier.DataSupplier;
import java.io.OutputStream;

public class PowerfulLinkedDataReader
extends LinkedDataReader {
    public PowerfulLinkedDataReader(DataSupplier dataSupplier) {
        super(dataSupplier);
    }

    public PowerfulLinkedDataReader() {
    }

    public int inputStreamRead() {
        boolean r = this.ensureAvailable();
        if (!r) {
            return -1;
        }
        byte b = this.head.bytes[this.head.position];
        ++this.head.position;
        return b;
    }

    public int inputStreamRead(byte[] b, int off, int len) {
        boolean r;
        if (len > 0 && !(r = this.ensureAvailable())) {
            return -1;
        }
        FillByteArrayDataConsumer consumer = new FillByteArrayDataConsumer(b, off, len);
        this.walk(consumer, len, true);
        return consumer.getFilledLength();
    }

    public long inputStreamTransferTo(OutputStream out, long maxLength) {
        boolean r;
        if (maxLength > 0L && !(r = this.ensureAvailable())) {
            return -1L;
        }
        OutputStreamDataConsumer consumer = new OutputStreamDataConsumer(out);
        this.walk(consumer, maxLength, true);
        return consumer.byteCount();
    }

    public long inputStreamTransferTo(OutputStream out) {
        return this.inputStreamTransferTo(out, Long.MAX_VALUE);
    }
}

