/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.zip;

import cool.scx.common.util.StringUtils;
import cool.scx.common.util.URIUtils;
import cool.scx.io.zip.PathZipBuilderItem;
import cool.scx.io.zip.ZipBuilderItem;
import cool.scx.io.zip.ZipOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class ZipBuilder {
    private final List<ZipBuilderItem> items = new ArrayList<ZipBuilderItem>();

    public ZipBuilder() {
    }

    public ZipBuilder(ZipFile zipFile) throws IOException {
        List<? extends ZipEntry> list = zipFile.stream().toList();
        for (ZipEntry zipEntry : list) {
            ZipBuilderItem i = new ZipBuilderItem(zipEntry, zipFile);
            this.items.add(i);
        }
    }

    public ZipBuilder(Path path) throws IOException {
        this.put(path);
    }

    public ZipBuilder(Path path, ZipOptions zipOptions) throws IOException {
        this.put(path, zipOptions);
    }

    public ZipBuilder put(String zipPath) {
        this.items.add(new ZipBuilderItem(zipPath));
        return this;
    }

    public ZipBuilder put(Path path, ZipOptions zipOptions) throws IOException {
        this.items.add(new PathZipBuilderItem("", path, zipOptions));
        return this;
    }

    public ZipBuilder put(Path path) throws IOException {
        return this.put(path, new ZipOptions());
    }

    public ZipBuilder put(String zipPath, Path path, ZipOptions zipOptions) throws IOException {
        this.items.add(new PathZipBuilderItem(zipPath, path, zipOptions));
        return this;
    }

    public ZipBuilder put(String zipPath, byte[] bytes) {
        this.items.add(new ZipBuilderItem(zipPath, bytes));
        return this;
    }

    public ZipBuilder put(String zipPath, InputStream inputStream) {
        this.items.add(new ZipBuilderItem(zipPath, inputStream));
        return this;
    }

    public ZipBuilder remove(String zipPath) {
        String p = URIUtils.normalize((String)zipPath);
        if (StringUtils.notBlank((String)zipPath)) {
            this.items.removeIf(c -> c.zipPath.startsWith(p));
        }
        return this;
    }

    public ZipBuilderItem get(String zipPath) {
        String p = URIUtils.normalize((String)zipPath);
        if (StringUtils.notBlank((String)zipPath)) {
            return this.items.stream().filter(c -> c.zipPath.startsWith(p)).findAny().orElse(null);
        }
        return null;
    }

    public List<ZipBuilderItem> items() {
        return this.items;
    }

    public void writeToZipOutputStream(ZipOutputStream zos) throws IOException {
        for (ZipBuilderItem i : this.items) {
            i.writeToZipOutputStream(zos);
        }
    }

    public byte[] toBytes(ZipOptions zipOptions) throws Exception {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try (ZipOutputStream zos = new ZipOutputStream((OutputStream)bo, zipOptions.charset());){
            zos.setComment(zipOptions.comment());
            zos.setLevel(zipOptions.level());
            this.writeToZipOutputStream(zos);
        }
        return bo.toByteArray();
    }

    public byte[] toBytes() throws Exception {
        return this.toBytes(new ZipOptions());
    }

    public Path toFile(Path outputPath, ZipOptions zipOptions) throws IOException {
        Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
        try (ZipOutputStream zos = new ZipOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]), zipOptions.charset());){
            zos.setComment(zipOptions.comment());
            zos.setLevel(zipOptions.level());
            this.writeToZipOutputStream(zos);
        }
        return outputPath;
    }

    public Path toFile(Path outputPath) throws IOException {
        return this.toFile(outputPath, new ZipOptions());
    }
}

