/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.io_stream;

import cool.scx.io.data_reader.DataReader;
import cool.scx.io.data_reader.LinkedDataReader;
import cool.scx.io.data_supplier.DataSupplier;
import cool.scx.io.exception.NoMoreDataException;
import cool.scx.io.io_stream.CheckedInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DataReaderInputStream
extends CheckedInputStream {
    private final DataReader dataReader;

    public DataReaderInputStream(DataReader dataReader) {
        this.dataReader = dataReader;
    }

    public DataReaderInputStream(DataSupplier dataSupplier) {
        this.dataReader = new LinkedDataReader(dataSupplier);
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        return this.dataReader.inputStreamRead();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        return this.dataReader.inputStreamRead(b, off, len);
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        this.ensureOpen();
        return this.dataReader.inputStreamTransferTo(out);
    }

    public DataReader dataReader() {
        return this.dataReader;
    }

    @Override
    public void mark(int readlimit) {
        this.dataReader.mark();
    }

    @Override
    public void reset() throws IOException {
        this.dataReader.reset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        try {
            return this.dataReader.read(len);
        }
        catch (NoMoreDataException e) {
            return new byte[0];
        }
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        try {
            return this.dataReader.read(Integer.MAX_VALUE);
        }
        catch (NoMoreDataException e) {
            return new byte[0];
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
    }
}

