/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.data_supplier;

import cool.scx.common.iterator.ArrayIterator;
import cool.scx.io.data_node.DataNode;
import cool.scx.io.data_supplier.DataSupplier;
import java.util.Iterator;
import java.util.List;

public class SequenceDataSupplier
implements DataSupplier {
    private final Iterator<DataSupplier> iterator;
    private DataSupplier currentSupplier;

    public SequenceDataSupplier(List<DataSupplier> dataSupplierList) {
        this.iterator = dataSupplierList.iterator();
        if (this.iterator.hasNext()) {
            this.currentSupplier = this.iterator.next();
        }
    }

    public SequenceDataSupplier(DataSupplier ... dataSupplierList) {
        this.iterator = new ArrayIterator((Object[])dataSupplierList);
        if (this.iterator.hasNext()) {
            this.currentSupplier = this.iterator.next();
        }
    }

    @Override
    public DataNode get() {
        while (this.currentSupplier != null) {
            DataNode dataNode = this.currentSupplier.get();
            if (dataNode != null) {
                return dataNode;
            }
            if (this.iterator.hasNext()) {
                this.currentSupplier = this.iterator.next();
                continue;
            }
            this.currentSupplier = null;
        }
        return null;
    }
}

