/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.data_consumer;

import cool.scx.io.data_consumer.DataConsumer;

public class FillByteArrayDataConsumer
implements DataConsumer {
    private final byte[] data;
    private final int dataPosition;
    private final int dataLength;
    private int i;

    public FillByteArrayDataConsumer(byte[] data, int position, int length) {
        this.data = data;
        this.dataPosition = position;
        this.dataLength = length;
        this.i = this.dataPosition;
    }

    @Override
    public boolean accept(byte[] bytes, int position, int length) {
        if (this.i + length > this.dataLength) {
            throw new IllegalStateException("Buffer overflow: not enough space to accept more data");
        }
        System.arraycopy(bytes, position, this.data, this.i, length);
        this.i += length;
        return true;
    }

    public int getFilledLength() {
        return this.i - this.dataPosition;
    }
}

