/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.data_reader;

import cool.scx.io.data_consumer.ByteArrayDataConsumer;
import cool.scx.io.data_consumer.DataConsumer;
import cool.scx.io.data_consumer.SkipDataConsumer;
import cool.scx.io.data_indexer.ByteIndexer;
import cool.scx.io.data_indexer.DataIndexer;
import cool.scx.io.data_indexer.KMPDataIndexer;
import cool.scx.io.exception.NoMatchFoundException;
import cool.scx.io.exception.NoMoreDataException;
import java.io.OutputStream;

public interface DataReader {
    public byte read() throws NoMoreDataException;

    public void read(DataConsumer var1, long var2, long var4) throws NoMoreDataException;

    public byte peek() throws NoMoreDataException;

    public void peek(DataConsumer var1, long var2, long var4) throws NoMoreDataException;

    public long indexOf(DataIndexer var1, long var2, long var4) throws NoMatchFoundException, NoMoreDataException;

    public void mark();

    public void reset();

    public int inputStreamRead();

    public int inputStreamRead(byte[] var1, int var2, int var3);

    public long inputStreamTransferTo(OutputStream var1, long var2);

    default public byte[] read(int maxLength) throws NoMoreDataException {
        return this.read(maxLength, Long.MAX_VALUE);
    }

    default public byte[] read(int maxLength, long maxPullCount) throws NoMoreDataException {
        ByteArrayDataConsumer consumer = new ByteArrayDataConsumer();
        this.read(consumer, maxLength, maxPullCount);
        return consumer.getBytes();
    }

    default public void read(DataConsumer dataConsumer, long maxLength) throws NoMoreDataException {
        this.read(dataConsumer, maxLength, Long.MAX_VALUE);
    }

    default public byte[] peek(int maxLength) throws NoMoreDataException {
        return this.peek(maxLength, Long.MAX_VALUE);
    }

    default public byte[] peek(int maxLength, long maxPullCount) throws NoMoreDataException {
        ByteArrayDataConsumer consumer = new ByteArrayDataConsumer();
        this.peek(consumer, maxLength, maxPullCount);
        return consumer.getBytes();
    }

    default public void peek(DataConsumer dataConsumer, long maxLength) throws NoMoreDataException {
        this.peek(dataConsumer, maxLength, Long.MAX_VALUE);
    }

    default public void skip(long length) throws NoMoreDataException {
        this.skip(length, Long.MAX_VALUE);
    }

    default public void skip(long length, long maxPullCount) throws NoMoreDataException {
        this.read(SkipDataConsumer.SKIP_DATA_CONSUMER, length, maxPullCount);
    }

    default public long indexOf(byte b) throws NoMatchFoundException, NoMoreDataException {
        return this.indexOf(b, Long.MAX_VALUE);
    }

    default public long indexOf(byte b, long maxLength) throws NoMatchFoundException, NoMoreDataException {
        return this.indexOf(b, maxLength, Long.MAX_VALUE);
    }

    default public long indexOf(byte b, long maxLength, long maxPullCount) throws NoMatchFoundException, NoMoreDataException {
        return this.indexOf(new ByteIndexer(b), maxLength, maxPullCount);
    }

    default public long indexOf(byte[] b) throws NoMatchFoundException, NoMoreDataException {
        return this.indexOf(b, Long.MAX_VALUE);
    }

    default public long indexOf(byte[] b, long maxLength) throws NoMatchFoundException, NoMoreDataException {
        return this.indexOf(b, maxLength, Long.MAX_VALUE);
    }

    default public long indexOf(byte[] b, long maxLength, long maxPullCount) throws NoMatchFoundException, NoMoreDataException {
        return this.indexOf(new KMPDataIndexer(b), maxLength, maxPullCount);
    }

    default public byte[] readUntil(byte b) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(b);
        byte[] data = this.read(Math.toIntExact(index));
        this.skip(1L);
        return data;
    }

    default public byte[] readUntil(byte b, int maxLength) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(b, (long)maxLength);
        byte[] data = this.read(Math.toIntExact(index));
        this.skip(1L);
        return data;
    }

    default public byte[] readUntil(byte[] b) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(b);
        byte[] data = this.read(Math.toIntExact(index));
        this.skip(b.length);
        return data;
    }

    default public byte[] readUntil(byte[] b, int maxLength) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(b, (long)maxLength);
        byte[] data = this.read(Math.toIntExact(index));
        this.skip(b.length);
        return data;
    }

    default public byte[] peekUntil(byte b) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(b);
        return this.peek(Math.toIntExact(index));
    }

    default public byte[] peekUntil(byte b, int maxLength) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(b, (long)maxLength);
        return this.peek(Math.toIntExact(index));
    }

    default public byte[] peekUntil(byte[] b) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(b);
        return this.peek(Math.toIntExact(index));
    }

    default public byte[] peekUntil(byte[] b, int maxLength) throws NoMatchFoundException, NoMoreDataException {
        long index = this.indexOf(b, (long)maxLength);
        return this.peek(Math.toIntExact(index));
    }

    default public long inputStreamTransferTo(OutputStream out) {
        return this.inputStreamTransferTo(out, Long.MAX_VALUE);
    }
}

