/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.zip;

import cool.scx.common.util.URIUtils;
import cool.scx.io.io_stream.NullCheckedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipBuilderItem {
    protected final String zipPath;
    protected final InputStream source;

    ZipBuilderItem(String zipPath, byte[] bytes) {
        this.zipPath = URIUtils.trimSlash((String)URIUtils.normalize((String)zipPath));
        this.source = new ByteArrayInputStream(bytes);
    }

    ZipBuilderItem(String zipPath, InputStream inputStream) {
        this.zipPath = URIUtils.trimSlash((String)URIUtils.normalize((String)zipPath));
        this.source = inputStream;
    }

    ZipBuilderItem(String zipPath) {
        this.zipPath = URIUtils.addSlashEnd((String)URIUtils.trimSlash((String)URIUtils.normalize((String)zipPath)));
        this.source = new NullCheckedInputStream();
    }

    ZipBuilderItem(ZipEntry zipEntry, ZipFile zipFile) throws IOException {
        this.zipPath = URIUtils.trimSlash((String)URIUtils.normalize((String)zipEntry.getName()));
        this.source = zipFile.getInputStream(zipEntry);
    }

    public void writeToZipOutputStream(ZipOutputStream zos) throws IOException {
        zos.putNextEntry(new ZipEntry(this.zipPath));
        this.source.transferTo(zos);
        zos.closeEntry();
    }

    public InputStream zipDataSource() {
        return this.source;
    }
}

