/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.data_reader;

import cool.scx.io.data_consumer.ByteArrayDataConsumer;
import cool.scx.io.data_consumer.DataConsumer;
import cool.scx.io.data_consumer.FillByteArrayDataConsumer;
import cool.scx.io.data_consumer.OutputStreamDataConsumer;
import cool.scx.io.data_indexer.DataIndexer;
import cool.scx.io.data_node.DataNode;
import cool.scx.io.data_reader.DataReader;
import cool.scx.io.data_supplier.DataSupplier;
import cool.scx.io.exception.DataSupplierException;
import cool.scx.io.exception.NoMatchFoundException;
import cool.scx.io.exception.NoMoreDataException;
import java.io.IOException;
import java.io.OutputStream;

public class LinkedDataReader
implements DataReader {
    public final DataSupplier dataSupplier;
    public DataNode head;
    public DataNode tail;
    public DataNode markNode;
    public int markNodePosition;

    public LinkedDataReader(DataSupplier dataSupplier) {
        this.dataSupplier = dataSupplier;
        this.tail = this.head = new DataNode(new byte[0]);
        this.markNode = null;
        this.markNodePosition = 0;
    }

    public LinkedDataReader() {
        this(() -> null);
    }

    public void appendData(DataNode data) {
        this.tail = this.tail.next = data;
    }

    public boolean pullData() throws DataSupplierException {
        DataNode data = this.dataSupplier.get();
        if (data == null) {
            return false;
        }
        this.appendData(data);
        return true;
    }

    public long ensureAvailable(long maxPullCount) throws DataSupplierException {
        long pullCount = 0L;
        while (!this.head.hasAvailable()) {
            if (this.head.next == null) {
                if (pullCount >= maxPullCount) break;
                boolean result = this.pullData();
                if (!result) {
                    return -1L;
                }
                ++pullCount;
            }
            this.head = this.head.next;
        }
        return pullCount;
    }

    public long ensureAvailableOrThrow(long maxPullCount) throws NoMoreDataException, DataSupplierException {
        long b = this.ensureAvailable(maxPullCount);
        if (b == -1L) {
            throw new NoMoreDataException();
        }
        return b;
    }

    public void walk(DataConsumer consumer, long maxLength, boolean movePointer, long maxPullCount) throws DataSupplierException {
        long remaining = maxLength;
        DataNode n = this.head;
        long pullCount = 0L;
        boolean needMore = true;
        while (remaining > 0L) {
            int length = (int)Math.min(remaining, (long)n.available());
            needMore = consumer.accept(n.bytes, n.position, length);
            remaining -= (long)length;
            if (movePointer) {
                n.position += length;
            }
            if (remaining <= 0L || !needMore) break;
            if (n.next == null) {
                boolean result;
                if (pullCount >= maxPullCount || !(result = this.pullData())) break;
                ++pullCount;
            }
            n = n.next;
            if (!movePointer) continue;
            this.head = n;
        }
    }

    public long findIndex(DataIndexer indexer, long maxLength, long maxPullCount) throws NoMatchFoundException, DataSupplierException {
        long index = 0L;
        DataNode n = this.head;
        long pullCount = 0L;
        while (true) {
            int length;
            int i;
            if ((i = indexer.indexOf(n.bytes, n.position, length = (int)Math.min((long)n.available(), maxLength - index))) != Integer.MIN_VALUE) {
                return index + (long)i;
            }
            if ((index += (long)length) >= maxLength) break;
            if (n.next == null) {
                boolean result;
                if (pullCount >= maxPullCount || !(result = this.pullData())) break;
                ++pullCount;
            }
            n = n.next;
        }
        throw new NoMatchFoundException();
    }

    @Override
    public byte read() throws NoMoreDataException, DataSupplierException {
        this.ensureAvailableOrThrow(Long.MAX_VALUE);
        byte b = this.head.bytes[this.head.position];
        ++this.head.position;
        return b;
    }

    @Override
    public void read(DataConsumer dataConsumer, long maxLength, long maxPullCount) throws NoMoreDataException, DataSupplierException {
        if (maxLength > 0L) {
            long pullCount = this.ensureAvailableOrThrow(maxPullCount);
            maxPullCount -= pullCount;
        }
        this.walk(dataConsumer, maxLength, true, maxPullCount);
    }

    @Override
    public byte peek() throws NoMoreDataException, DataSupplierException {
        this.ensureAvailableOrThrow(Long.MAX_VALUE);
        return this.head.bytes[this.head.position];
    }

    @Override
    public void peek(DataConsumer dataConsumer, long maxLength, long maxPullCount) throws NoMoreDataException, DataSupplierException {
        if (maxLength > 0L) {
            long pullCount = this.ensureAvailableOrThrow(maxPullCount);
            maxPullCount -= pullCount;
        }
        this.walk(dataConsumer, maxLength, false, maxPullCount);
    }

    @Override
    public long indexOf(DataIndexer indexer, long maxLength, long maxPullCount) throws NoMatchFoundException, NoMoreDataException, DataSupplierException {
        if (maxLength > 0L) {
            long pullCount = this.ensureAvailableOrThrow(maxPullCount);
            maxPullCount -= pullCount;
        }
        return this.findIndex(indexer, maxLength, maxPullCount);
    }

    @Override
    public void mark() {
        this.markNode = this.head;
        this.markNodePosition = this.head.position;
    }

    @Override
    public void reset() {
        if (this.markNode == null) {
            return;
        }
        this.head = this.markNode;
        this.head.position = this.markNodePosition;
        DataNode n = this.head.next;
        while (n != null) {
            n.reset();
            n = n.next;
        }
    }

    @Override
    public int inputStreamRead() throws IOException {
        try {
            long pullCount = this.ensureAvailable(1L);
            if (pullCount == -1L) {
                return -1;
            }
            byte b = this.head.bytes[this.head.position];
            ++this.head.position;
            return b & 0xFF;
        }
        catch (DataSupplierException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IOException) {
                IOException i = (IOException)throwable;
                throw i;
            }
            throw e;
        }
    }

    @Override
    public int inputStreamRead(byte[] b, int off, int len) throws IOException {
        try {
            long maxPullCount = 1L;
            if (len > 0) {
                long pullCount = this.ensureAvailable(maxPullCount);
                if (pullCount == -1L) {
                    return -1;
                }
                maxPullCount -= pullCount;
            }
            FillByteArrayDataConsumer consumer = new FillByteArrayDataConsumer(b, off, len);
            this.walk(consumer, len, true, maxPullCount);
            return consumer.getFilledLength();
        }
        catch (DataSupplierException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IOException) {
                IOException i = (IOException)throwable;
                throw i;
            }
            throw e;
        }
    }

    @Override
    public long inputStreamTransferTo(OutputStream out, long maxLength) throws IOException {
        try {
            long pullCount;
            if (maxLength > 0L && (pullCount = this.ensureAvailable(Long.MAX_VALUE)) == -1L) {
                return 0L;
            }
            OutputStreamDataConsumer consumer = new OutputStreamDataConsumer(out);
            this.walk(consumer, maxLength, true, Long.MAX_VALUE);
            return consumer.byteCount();
        }
        catch (DataSupplierException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IOException) {
                IOException i = (IOException)throwable;
                throw i;
            }
            throw e;
        }
    }

    @Override
    public byte[] inputStreamReadNBytes(long len) throws IOException {
        try {
            long pullCount;
            if (len > 0L && (pullCount = this.ensureAvailable(Long.MAX_VALUE)) == -1L) {
                return new byte[0];
            }
            ByteArrayDataConsumer consumer = new ByteArrayDataConsumer();
            this.walk(consumer, len, true, Long.MAX_VALUE);
            return consumer.getBytes();
        }
        catch (DataSupplierException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IOException) {
                IOException i = (IOException)throwable;
                throw i;
            }
            throw e;
        }
    }
}

