/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.data_supplier;

import cool.scx.io.data_node.DataNode;
import cool.scx.io.data_supplier.DataSupplier;
import cool.scx.io.exception.DataSupplierException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class BufferedByteChannelDataSupplier
implements DataSupplier {
    private final ReadableByteChannel dataChannel;
    private final ByteBuffer buffer;

    public BufferedByteChannelDataSupplier(ReadableByteChannel dataChannel, int bufferLength) {
        this.dataChannel = dataChannel;
        this.buffer = ByteBuffer.allocate(bufferLength);
    }

    public BufferedByteChannelDataSupplier(ReadableByteChannel dataChannel) {
        this(dataChannel, 8192);
    }

    @Override
    public DataNode get() throws DataSupplierException {
        try {
            this.buffer.clear();
            int i = this.dataChannel.read(this.buffer);
            if (i == -1) {
                return null;
            }
            byte[] data = new byte[i];
            this.buffer.flip().get(data);
            return new DataNode(data);
        }
        catch (IOException e) {
            throw new DataSupplierException(e);
        }
    }
}

