/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.data_supplier;

import cool.scx.io.data_node.DataNode;
import cool.scx.io.data_supplier.DataSupplier;
import cool.scx.io.exception.DataSupplierException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ByteChannelDataSupplier
implements DataSupplier {
    private final ReadableByteChannel dataChannel;
    private final int bufferLength;
    private final boolean compress;

    public ByteChannelDataSupplier(ReadableByteChannel dataChannel) {
        this(dataChannel, 8192, false);
    }

    public ByteChannelDataSupplier(ReadableByteChannel dataChannel, boolean compress) {
        this(dataChannel, 8192, compress);
    }

    public ByteChannelDataSupplier(ReadableByteChannel dataChannel, int bufferLength) {
        this(dataChannel, bufferLength, false);
    }

    public ByteChannelDataSupplier(ReadableByteChannel dataChannel, int bufferLength, boolean compress) {
        this.dataChannel = dataChannel;
        this.bufferLength = bufferLength;
        this.compress = compress;
    }

    @Override
    public DataNode get() throws DataSupplierException {
        try {
            ByteBuffer bytes = ByteBuffer.allocate(this.bufferLength);
            int i = this.dataChannel.read(bytes);
            if (i == -1) {
                return null;
            }
            if (i == this.bufferLength) {
                return new DataNode(bytes.array());
            }
            if (this.compress) {
                byte[] data = new byte[i];
                System.arraycopy(bytes.array(), 0, data, 0, i);
                return new DataNode(data);
            }
            return new DataNode(bytes.array(), 0, i);
        }
        catch (IOException e) {
            throw new DataSupplierException(e);
        }
    }
}

