/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.file;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.function.Consumer;

public final class FileWatcher {
    private final WatchService watchService = FileSystems.getDefault().newWatchService();
    private final Path target;
    private final Path watchTarget;
    private final boolean isFile;
    private Thread watchThread;
    private Consumer<ChangeEvent> listener;

    public FileWatcher(Path target) throws IOException {
        this.target = target;
        this.isFile = !Files.isDirectory(target, new LinkOption[0]);
        this.watchTarget = this.isFile ? target.getParent() : target;
        this.watchTarget.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
    }

    public void _do() {
        WatchKey watchKey;
        boolean valid;
        do {
            try {
                watchKey = this.watchService.take();
            }
            catch (InterruptedException e) {
                break;
            }
            List<WatchEvent<?>> watchEvents = watchKey.pollEvents();
            for (WatchEvent<?> event : watchEvents) {
                Path eventPath = (Path)event.context();
                WatchEvent.Kind<?> eventKind = event.kind();
                eventPath = this.watchTarget.resolve(eventPath);
                if (this.isFile && !this.target.equals(eventPath)) continue;
                this._callListener(eventPath, eventKind);
            }
        } while (valid = watchKey.reset());
    }

    public FileWatcher listener(Consumer<ChangeEvent> listener) {
        this.listener = listener;
        return this;
    }

    private void _callListener(Path target, WatchEvent.Kind<?> kind) {
        if (this.listener != null) {
            this.listener.accept(new ChangeEvent(target, ChangeEventType.of(kind)));
        }
    }

    public FileWatcher start() {
        this.watchThread = Thread.ofPlatform().name("FileWatcher-WatchThread").start(this::_do);
        return this;
    }

    public void stop() {
        if (this.watchThread != null) {
            this.watchThread.interrupt();
            this.watchThread = null;
        }
        try {
            this.watchService.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public record ChangeEvent(Path target, ChangeEventType type) {
    }

    public static enum ChangeEventType {
        MODIFY,
        DELETED,
        CREATED;


        public static ChangeEventType of(WatchEvent.Kind<?> t) {
            if (t == StandardWatchEventKinds.ENTRY_CREATE) {
                return CREATED;
            }
            if (t == StandardWatchEventKinds.ENTRY_MODIFY) {
                return MODIFY;
            }
            if (t == StandardWatchEventKinds.ENTRY_DELETE) {
                return DELETED;
            }
            throw new IllegalArgumentException("\u672a\u77e5\u7c7b\u578b : " + t.toString());
        }
    }
}

