/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.data_consumer;

import cool.scx.io.data_consumer.DataConsumer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;

public class OutputStreamDataConsumer
implements DataConsumer {
    private final OutputStream out;
    private long byteCount;

    public OutputStreamDataConsumer(OutputStream out) {
        this.out = out;
        this.byteCount = 0L;
    }

    @Override
    public boolean accept(byte[] bytes, int position, int length) {
        try {
            this.out.write(bytes, position, length);
            this.byteCount += (long)length;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return true;
    }

    public long byteCount() {
        return this.byteCount;
    }
}

