/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.io.data_consumer;

import cool.scx.io.IOHelper;
import cool.scx.io.data_consumer.DataConsumer;
import cool.scx.io.data_node.DataNode;

public class ByteArrayDataConsumer
implements DataConsumer {
    private DataNode head = null;
    private DataNode tail = null;
    private int total = 0;

    @Override
    public boolean accept(byte[] bytes, int position, int length) {
        this.total += length;
        DataNode dataNode = new DataNode(bytes, position, position + length);
        this.tail = this.head == null ? (this.head = dataNode) : (this.tail.next = dataNode);
        return true;
    }

    public byte[] getBytes() {
        DataNode node = this.head;
        if (node == null) {
            return new byte[0];
        }
        if (node.next == null) {
            return IOHelper.compressBytes(node.bytes, node.position, node.available());
        }
        byte[] bytes = new byte[this.total];
        int offset = 0;
        do {
            int length = node.available();
            System.arraycopy(node.bytes, node.position, bytes, offset, length);
            offset += length;
        } while ((node = node.next) != null);
        return bytes;
    }
}

